<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $db,$sugar_config;
// ottengo gli headers HTTP inviati dal client
$headers = getallheaders();
// normalizzo gli headers 
$headers = array_change_key_case($headers, CASE_LOWER);
// Leggi il raw input
$json_input = file_get_contents('php://input');
$input_data = json_decode($json_input, true);

//********* FUNZIONI  *******/

function getJWTuserId($at){
    // Rimuovi "Bearer " se presente
    $token = str_replace('Bearer ', '', $at);
    
    // Verifica che il token abbia 3 parti separate da punti
    $parts = explode('.', $token);
    if (count($parts) !== 3) {
        return false; // Token JWT non valido
    }
    
    // Decodifica il payload (seconda parte del JWT)
    $payload = $parts[1];
    
    // Aggiungi padding se necessario per base64_decode
    $payload = str_pad($payload, strlen($payload) % 4, '=', STR_PAD_RIGHT);
    
    // Decodifica il payload
    $decoded_payload = json_decode(base64_decode($payload), true);
    
    // Verifica che la decodifica sia andata a buon fine
    //write_to_log($decoded_payload,"debug");
    if ($decoded_payload !== null) {
        
        write_to_log(array(),$decoded_payload['sub']);
        // Creo un bean del modulo Users con l'ID estratto dal JWT
        $user_bean = BeanFactory::getBean('Users', $decoded_payload['sub']);
        write_to_log(array(),$user_bean->qrcode_c);
    }
}


function createXapiRecord($at,$body) {
    global $sugar_config;
    // ottengo l'url di base dell'installazione SuiteCRM
    $base_url=$sugar_config['site_url'];
    // ottengo l'url della chiamata per creare un record del modulo "xa_xApi"
    $url = $base_url.'/Api/V8/module';

    //$name=$body['data']['attributes']['name'];
    $name = isset($_GET['entryPoint']) ? $_GET['entryPoint'] : '';
    // verifico se l'entry point è xApi allora il nome lo prendo dal nome del campo name - per Etos che avrà la vecchia API -
    if($name=='xApi'){
        $name = $body['data']['attributes']['name'];
    }

    // creo il body per la chiamata
    $body_check=array(
        "data"=>array(
            "type"=>"xa_xApi",
            "attributes"=>array(
                "name"=>$name
            )
        )
      );
  
      $json_check=json_encode( $body_check );

    // creo un oggetto MyHgFunction per la chiamata HTTP
    $myCurl=new MyHgFunction($url);

    
    ob_start();
    try{
        $header_check=array(
        'Content-Type: application/json',
        'Authorization: '.$at
        );

        $myCurl->setHeader($header_check);

        $result = $myCurl->myCall($json_check, 'POST');

        // Decodifica il risultato JSON
        $response = json_decode($result, true);
        
        // Verifica se il token è presente nella risposta
        if (isset($response['data']['id'])) {
            // mi salvo l'id del record creato
            $xApiId = $response['data']['id'];
            
            //write_to_log(array(),$at);

            //getJWTuserId($at);
            
            // procedo con la richiesta relativa al nome passato come parametro
            switch ($name) {
                // eseguo la richiesta per il ticket
                // creo un compito per il backoffice
                case 'newTicket':
                    try {
                        require_once('require/invia_ticket.php');
                    } catch (Exception $e) {
                        // scrivo l'errore nei log di SuiteCRM
                        $GLOBALS['log']->error('Errore durante la creazione del ticket: '. $e->getMessage());
                        ob_end_clean();
                        return false;
                    }
                    break;
                // recupero i dati della fidelity dal CRM 
                case 'datiFidelity':
                    
                    try {
                        ob_end_clean();
                        require_once('require/dati_fidelity.php');
                    } catch (Exception $e) {
                        // scrivo l'errore nei log di SuiteCRM
                        $GLOBALS['log']->error('Errore durante il recupero dei dati della fidelity: '. $e->getMessage());
                        ob_end_clean();
                        return false;
                    }
                    break;
                // recupero i dati dei crediti della fidelity dal CRM 
                case 'creditiFidelity':
                    
                    try {
                        ob_end_clean();
                        require_once('require/crediti_fidelity.php');
                    } catch (Exception $e) {
                        // scrivo l'errore nei log di SuiteCRM
                        $GLOBALS['log']->error('Errore durante il recupero dei dati dei crediti della fidelity: '. $e->getMessage());
                        ob_end_clean();
                        return false;
                    }
                    break;   
                // recupero i dati del singolo scontrino dato il codice e la matricola
                case 'billFidelity':
                    
                    try {
                        ob_end_clean();
                        require_once('require/scontrino_fidelity.php');
                    } catch (Exception $e) {
                        // scrivo l'errore nei log di SuiteCRM
                        $GLOBALS['log']->error('Errore durante il recupero dei dati dello scontrino della fidelity: '. $e->getMessage());
                        ob_end_clean();
                        return false;
                    }
                    break;  
                // conferma fidelity allineata da ETOS 
                case 'allineata':
                    
                    try {
                        ob_end_clean();
                        require_once('require/allineata.php');
                    } catch (Exception $e) {
                        // scrivo l'errore nei log di SuiteCRM
                        $GLOBALS['log']->error('Errore durante la conferma di allineamento della Fidelity da Etos: '. $e->getMessage());
                        ob_end_clean();
                        return false;
                    }
                    break;
                // salvo i dati dello scontrino proveniente da ETOS e faccio partire il flusso di ricalcolo punti e premialità
                case 'sendScontrino':
                    
                    try {
                        ob_end_clean();
                        require_once('require/sendScontrino.php');
                    } catch (Exception $e) {
                        // scrivo l'errore nei log di SuiteCRM
                        $GLOBALS['log']->error('Errore durante il salvataggio dello scontrino: '. $e->getMessage());
                        ob_end_clean();
                        return false;
                    }
                    break;
                // recupero i dati della fidelity dal CRM 
                case 'vecchioCliente':
                    
                    try {
                        ob_end_clean();
                        require_once('require/vecchio_cliente.php');
                    } catch (Exception $e) {
                        // scrivo l'errore nei log di SuiteCRM
                        $GLOBALS['log']->error('Errore durante la verifica della presenza di un vecchio account: '. $e->getMessage());
                        ob_end_clean();
                        return false;
                    }
                    break;
                // effettuo update dei dati della fidelity nel CRM 
                case 'updAnagFidelity':
                    
                    try {
                        ob_end_clean();
                        require_once('require/upd_anag_fidelity.php');
                    } catch (Exception $e) {
                        // scrivo l'errore nei log di SuiteCRM
                        $GLOBALS['log']->error('Errore durante l\'update dei dati della Fidelity: '. $e->getMessage());
                        ob_end_clean();
                        return false;
                    }
                    break;
            }
            ob_end_clean();
            return true;
        } else {
            ob_end_clean();
            return false;
        }
    } catch (Exception $e) {
        ob_end_clean();
        return false;
    }
    exit;
}
// ******** Fine **********/

// verifico se presente la chiave 'Authorization' nel header
if(isset($headers['authorization'])) {
    // recupero l'authorization token
    $at = $headers['authorization'];
    // verifico se il token è valido controllo se è presente la parola "Bearer"
    if(strpos($at, 'Bearer ') === 0) {
        //write_to_log($input_data,'debug');
        // faccio la chiamata alle API di SuiteCRM per creare un record del modulo "xa_xApi" e ritorno se tutto è andato a buon fine
        if (createXapiRecord($at, $input_data)) {
            // creazione del record è andata a buon fine, restituisco un codice 200 OK
            // eseguo quanto richiesto dal tipo di richiesta xApi
            header_remove('Set-Cookie');
            header('Content-Type: application/json; charset=utf-8');
            http_response_code(200);
            echo json_encode(['message' => 'ok']);
        } else {
            header_remove('Set-Cookie');
            header('Content-Type: application/json; charset=utf-8');
            // creazione del record non è andata a buon fine, restituisco un codice 400 Bad Request
            http_response_code(401);
            echo json_encode(['message' => 'Token non valido, creazione record in xApi non riuscita']);
        }
    } else {
        // Token non valido (non contiene "Bearer")
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(401);
        echo json_encode(['message' => 'Token di autorizzazione non valido']);
    }
} else {
    // non è presente la chiave 'Authorization' nel header, restituisco un codice 401 Unauthorized
    header_remove('Set-Cookie');
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(401);
    echo json_encode(['message' => 'Token non presente nel header Authorization']);
}