<?php
global $db,$sugar_config;
try{
    // Validazione presenza parametro
    $uid=$BeanUser->qrcode_c;

    if (!isset($body['data']['attributes']['oldId'])) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Parametro oldId è obbligatorio']);
        exit;
    }
    
    $oldId = trim($body['data']['attributes']['oldId']);

    // verifico se $uid non è vuoto
    // Validazione formato UID
    if (empty($uid) || strlen($uid) > 100 || !preg_match('/^[a-zA-Z0-9\-_]+$/', $uid)) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'UID non valido']);
        exit;
    }

    // Validazione oldId alfanumerico (compatibile con VARCHAR)
    if (empty($oldId) || strlen($oldId) > 50 || !preg_match('/^[a-zA-Z0-9_-]+$/', $oldId)) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'oldId non valido']);
        exit;
    }

    $bean = BeanFactory::getBean('FC_FidelityCard');
    // ottengo i dati della fidelity legati al guid
    // Cerco tra tutti i record del Bean FC_FidelityCard se il valore del uid è presente nel campo custom 'guid_webapp_c'
    if (!$bean) {
        throw new Exception('Impossibile inizializzare il bean FC_FidelityCard');
    }

    
   // Metodo sicuro usando retrieve_by_string_fields
    $fidelityCard = $bean->retrieve_by_string_fields(array(
        'guid_webapp_c' => $uid,
        'deleted' => 0
    ));

    if ($fidelityCard && !empty($fidelityCard->id)) {

        // il guid è stato trovato in un record FC_FidelityCard
        // recupero i dati della fidelity
        $beanFidelityCard = $fidelityCard;

        // faccio query in ETOS per recuperare i dati del vecchio utente
        // verifico se la fidelity è allineata (processata da ETOS) e se non è già stato usato il recupero del vecchio cliente
        if($beanFidelityCard->inetos_c==1 && $beanFidelityCard->vecchio_cliente_c==0){
            if(isVecchioCliente($oldId,$beanFidelityCard)){

                
                if (!isset($sugar_config['add_punteggio_old_fidelity']) || 
                    !is_numeric($sugar_config['add_punteggio_old_fidelity']) ||
                    $sugar_config['add_punteggio_old_fidelity'] < 0) {
                    throw new Exception('Configurazione punteggio non valida o mancante');
                }
                $punteggio_da_aggiungere = (float)$sugar_config['add_punteggio_old_fidelity'];

                // Validazione punteggio attuale
                $punteggio_attuale = (float)$beanFidelityCard->punteggio_totale_c;
                if ($punteggio_attuale < 0) {
                    $punteggio_attuale = 0; // Normalizza valori negativi
                }

                // Calcolo sicuro
                $nuovo_punteggio = $punteggio_attuale + $punteggio_da_aggiungere;

                // Validazione risultato
                if ($nuovo_punteggio < 0 ) {
                    throw new Exception('Punteggio risultante non valido: ' . $nuovo_punteggio);
                }

                $beanFidelityCard->punteggio_totale_c = $nuovo_punteggio;
                $beanFidelityCard->vecchio_cliente_c = 1;
                $beanFidelityCard->inetos_c = 0;
                //$beanFidelityCard->oldid_c = $oldId;

                // Controllo salvataggio
                if (!$beanFidelityCard->save()) {
                    throw new Exception('Errore durante il salvataggio dei dati');
                }

                $beanEmail = new SugarEmailAddress; 

                $email=$beanEmail->getPrimaryAddress($beanFidelityCard); 

                assegnaFascieFidelity($beanFidelityCard, $beanFidelityCard->punteggio_totale_c);

                creaRecordInETOS($beanFidelityCard,$email);

                header_remove('Set-Cookie');
                // Il token JWT è presente, restituiscilo con header 200 OK
                header('Content-Type: application/json; charset=utf-8');
                http_response_code(200);
                echo json_encode(['message' => 'Vecchio utente recuperato.']);
                exit;
            }
            else{
                // se non è un vecchio cliente, restituisco un errore 400 Not Found
                header_remove('Set-Cookie');
                // Il token JWT è presente, restituiscilo con header 200 OK
                header('Content-Type: application/json; charset=utf-8');
                http_response_code(400);
                echo json_encode(['message' => 'Non è possibile recuperare i dati del vecchio cliente.'],JSON_UNESCAPED_UNICODE);
                exit;
            }
        } else {
            // se la fidelity non è allineata o è già stato usato il recupero del vecchio cliente, restituisco un errore 403 Forbidden
            header_remove('Set-Cookie');
            header('Content-Type: application/json; charset=utf-8');
            http_response_code(400);
            echo json_encode(['message' => 'FidelityCard non allineata in ETOS o già recuperato il vecchio cliente.'],JSON_UNESCAPED_UNICODE);
            exit;
        }
        
    } else {
        // Nessun record trovato con questo guid
        header_remove('Set-Cookie');
        // Il token JWT è presente, restituiscilo con header 200 OK
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Nessuna FidelityCard trovata con questo uid']);
        exit;
    }
} catch (Exception $e) {
    header_remove('Set-Cookie');
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(500);
    echo json_encode(['message' => 'Errore critico nel recupero vecchio cliente: ' . $e->getMessage()]);
    exit;
}
?>