<?php
try{
    // Validazione presenza parametro
    $uid="";
    // Validazione presenza parametro
    if (!isset($body['data']['attributes']['uid'])) {
        $uid=$BeanUser->qrcode_c;
    }
    else{
        // ottengo l'id della fidelity legato al guid 
        $uid = trim($body['data']['attributes']['uid']);
    }

    // Validazione presenza type
    if (!isset($body['data']['attributes']['type'])) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode([
            'message' => 'Parametro type è obbligatorio',
        ]);
        exit;
    }

    // Validazione presenza data
    if (!isset($body['data']['attributes']['data'])) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode([
            'message' => 'Parametro data è obbligatorio',
        ]);
        exit;
    }

    // Sanitizzazione input
    $type = trim($body['data']['attributes']['type']);
    $data = $body['data']['attributes']['data'];

    
    // Validazione che $data sia un array
    if (!is_array($data)) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Dati anagrafici malformati']);
        exit;
    }

    //  Validazione campi obbligatori nei dati
    $requiredFields = ['displayName', 'email'];
    foreach ($requiredFields as $field) {
        if (!isset($data[$field]) || empty(trim($data[$field]))) {
            header_remove('Set-Cookie');
            header('Content-Type: application/json; charset=utf-8');
            http_response_code(400);
            echo json_encode(['message' => "Campo obbligatorio mancante: {$field}"]);
            exit;
        }
    }

    
    // Sanitizzazione e validazione dei singoli campi
    $displayName = trim($data['displayName']);
    $phone = isset($data['phone']) && !empty(trim($data['phone'])) ? trim($data['phone']) : "";
    $dataNascita = isset($data['data_nascita']) && !empty(trim($data['data_nascita'])) ? trim($data['data_nascita']) : "";
    $email = trim($data['email']);
    $consenso1 = $data['consenso1'];
    $consenso2 = $data['consenso2'];

    //write_to_log(array(),"phone:" .$phone);

    // Validazione displayName
    if (strlen($displayName) > 100 || !preg_match('/^[\p{L}\s\-\'\.]+$/u', $displayName)) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Nome non valido (max 100 caratteri, solo lettere, spazi, apostrofi, trattini)']);
        exit;
    }

    // Validazione phone
    if($phone != "") {
        if (strlen($phone) > 20 || !preg_match('/^[\d\s\+\-\(\)]+$/', $phone)) {
            header_remove('Set-Cookie');
            header('Content-Type: application/json; charset=utf-8');
            http_response_code(400);
            echo json_encode(['message' => 'Numero di telefono non valido']);
            exit;
        }
    }

    // Validazione email
    if (strlen($email) > 100 ||!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Email non valida (max 100 caratteri, formato email)']);
        exit;
    }

    // Validazione consenso1 deve essere un intero 0 o 1
    if (!in_array($consenso1, [0, 1])) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Valore di consenso 1 non valido. Valori ammessi: 0, 1']);
        exit;
    }


    // Validazione consenso2 deve essere un intero 0 o 1
    if (!in_array($consenso2, [0, 1])) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Valore di consenso 2 non valido. Valori ammessi: 0, 1']);
        exit;
    }


    // CORREZIONE CRITICA: Validazione e conversione data sicura
    
    // CORREZIONE CRITICA: Validazione e conversione data sicura
    if($dataNascita != "") {
        if (!preg_match('/^\d{8}$/', $dataNascita)) {
            header_remove('Set-Cookie');
            header('Content-Type: application/json; charset=utf-8');
            http_response_code(400);
            echo json_encode(['message' => 'Formato data nascita non valido. Richiesto: YYYYMMDD']);
            exit;
        }
    

        // Conversione sicura della data
        $year = substr($dataNascita, 0, 4);
        $month = substr($dataNascita, 4, 2);
        $day = substr($dataNascita, 6, 2);

        // Validazione data
        if (!checkdate($month, $day, $year)) {
            header_remove('Set-Cookie');
            header('Content-Type: application/json; charset=utf-8');
            http_response_code(400);
            echo json_encode(['message' => 'Data di nascita non valida']);
            exit;
        
        }
        // il formato della data di nascita deve essere Y-m-d
        $dataFormattata = "{$year}-{$month}-{$day}";
    }
    else {
        $dataFormattata = "";
    }

    // SICUREZZA: Validazione type
    if (!in_array($type, ['etos', 'webapp'])) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Tipologia chiamata non valida. Valori ammessi: etos, webapp']);
        exit;
    }


    // ottengo i dati della fidelity legati al guid
    // Cerco tra tutti i record del Bean FC_FidelityCard se il valore del uid è presente nel campo custom 'guid_webapp_c'
    $bean = BeanFactory::getBean('FC_FidelityCard');

    if (!$bean) {
        throw new Exception('Impossibile inizializzare il bean FC_FidelityCard');
    }

   // Metodo sicuro usando retrieve_by_string_fields
    $fidelityCard = $bean->retrieve_by_string_fields(array(
        'guid_webapp_c' => $uid,
        'deleted' => 0
    ));

    if ($fidelityCard && !empty($fidelityCard->id)) {

        // il guid è stato trovato in un record FC_FidelityCard
        // recupero i dati della fidelity
        $beanFidelityCard = $fidelityCard;

        $beanFidelityCard->first_name = $displayName;
        if($phone != "") {        
            $beanFidelityCard->phone_home = $phone;
        }
        if($dataNascita!= "") {              
            $beanFidelityCard->data_nascita_c = $dataFormattata; 
        }
        $beanFidelityCard->inetos_c = 0;
        $beanFidelityCard->indmail_c = $email;
        $beanFidelityCard->consenso1_c = $consenso1;
        $beanFidelityCard->consenso2_c = $consenso2;
        // Salvataggio con controllo errori
        if (!$beanFidelityCard->save()) {
            throw new Exception('Errore durante il salvataggio dei dati');
        }

        // verifico il tipo di chiamata 
        if ($type == 'etos') {
            // codice per la gestione di etos
            // mi salvo lo uid nel record xApi 
            $BeanXapi = BeanFactory::getBean('xa_xApi', $xApiId);
            $BeanXapi->description = $uid;
            $BeanXapi->save();
        } elseif ($type == 'webapp') {
            // codice per la gestione di webapp
            // aggiorno i dati in ETOS
            // ottengo l'indirizzo mail della fidelity
            $beanEmail = new SugarEmailAddress; 

            //$email=$beanEmail->getPrimaryAddress($beanFidelityCard); 

            creaRecordInETOS($beanFidelityCard,$email);
        } 
        $response = array(
            'operazione' => 1
        );

        header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(200);
        echo json_encode($response);
        exit;
    } else {
        // Nessun record trovato con questo guid
        header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Nessuna FidelityCard trovata con questo uid']);
        exit;
    }
} catch (Exception $e) {
    header_remove('Set-Cookie');
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(500);
    echo json_encode(['message' => 'Errore critico nella modifica dei dati anagrafici: ' . $e->getMessage()]);
    exit;
}
?>