<?php
// ottengo l'id della fidelity legato al guid 
$uid = $body['data']['attributes']['uid'];
// ottengo lo scontrino
$scontrino = $body['data']['attributes']['bill'];


// verifico se $uid non è vuoto
if(empty($uid)){
    // se $uid è vuoto, restituisco un errore 400 Bad Request
    header_remove('Set-Cookie');
    // Il token JWT è presente, restituiscilo con header 200 OK
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(400);
    echo json_encode(['message' => 'uid non presente']);
    exit;
}

// mi salvo lo uid nel record xApi 
$BeanXapi = BeanFactory::getBean('xa_xApi', $xApiId);
$BeanXapi->description = $uid;
$BeanXapi->save();

// verifico se $scontrino non è vuoto

if(empty($scontrino)){
    // se $scontrino è vuoto, restituisco un errore 400 Bad Request
    header_remove('Set-Cookie');
    // Il token JWT è presente, restituiscilo con header 200 OK
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(400);
    echo json_encode(['message' => 'scontrino non presente']);
    exit;
}

// codice scontrino
$codBill=$scontrino['codice'];
// matricola scontrino
$matricola=$scontrino['matricola'];
// totale scontrino
$totaleScontrino=$scontrino['totale'];

// ottengo i dati della fidelity legati al guid
// Cerco tra tutti i record del Bean FC_FidelityCard se il valore del uid è presente nel campo custom 'guid_webapp_c'
$bean = BeanFactory::getBean('FC_FidelityCard');

// Sanitizzazione dell'input per prevenire SQL injection
$sanitized_uid = addslashes($uid);

$beanList = $bean->get_list(
    'first_name',
    "guid_webapp_c = '$sanitized_uid'",
    0,
    -1
);

if (!empty($beanList['list'])) {
        
    // il guid è stato trovato in un record FC_FidelityCard
    // recupero i dati della fidelity
    $fidelity = $beanList['list'][0];
    
    $beanFidelityCard = BeanFactory::getBean('FC_FidelityCard', $fidelity->id);

    // creo un nuovo record CRF_crediti_fidelity
    $beanCrf = BeanFactory::getBean('CRF_crediti_fidelity');

    // verifico se esiste già un record FC_FidelityCard che ha il campo codscontrino_c = $codBill
    $beanCreditiFidelityList = $beanCrf->get_list(
        'id',
        "codscontrino_c = '$codBill' and matricola_c = '$matricola'",
        0,
        -1
    );

    if (empty($beanCreditiFidelityList['list'])) {
        //write_to_log(array(),"debug: Non c'è Scontrino per Fidelity card trovata con uid: $sanitized_uid , codice: $codBill");
        // creo un nuovo record CRF_crediti_fidelity
        $beanCreditiFidelity = BeanFactory::newBean('CRF_crediti_fidelity');
        // Rimuoviamo i punti (separatori delle migliaia) e sostituiamo la virgola con il punto
        $totaleScontrinoClean = str_replace('.', '', $totaleScontrino);
        $totaleScontrinoClean = str_replace(',', '.', $totaleScontrinoClean);
        // Convertiamo la stringa pulita in float
        $totaleScontrinoFloat = floatval($totaleScontrinoClean);
        // Convertiamo la stringa pulita in float
        $beanCreditiFidelity->totalespesa_c = number_format($totaleScontrinoFloat, 2, '.', '');
    
        $beanCreditiFidelity->codscontrino_c = $codBill;
        $beanCreditiFidelity->matricola_c = $matricola;
        $beanCreditiFidelity->jsonscontrino_c = json_encode($scontrino);
        $beanCreditiFidelity->save();

        // aggiungo la relazione tra la fidelity e il nuovo record CRF_crediti_fidelity mediante la relazione fc_fidelitycard_crf_crediti_fidelity_1
        $beanFidelityCard->load_relationship('fc_fidelitycard_crf_crediti_fidelity_1');
        $beanFidelityCard->fc_fidelitycard_crf_crediti_fidelity_1->add($beanCreditiFidelity);

        $punteggio = calcoloPunteggio($totaleScontrino,$beanFidelityCard);

        $beanCreditiFidelity->punteggio_c = $punteggio;
        $beanCreditiFidelity->save();

        // aggiorno il punteggio totale della fidelity
        $beanFidelityCard->punteggio_totale_c += $punteggio;
        $beanFidelityCard->save();
        // verifico se è necessario assegnare una fascia di fidelity
        assegnaFascieFidelity($beanFidelityCard, $beanFidelityCard->punteggio_totale_c);
        // aggiorno punteggi in ETOS facendo una scrittura nella tabella di interscambio con ETOS 
        // ottengo l'indirizzo mail della fidelity
        $beanEmail = new SugarEmailAddress; 

        $email=$beanEmail->getPrimaryAddress($beanFidelityCard); 

        $beanFidelityCard->inetos_c = 0;

        $beanFidelityCard->save();

        creaRecordInETOS($beanFidelityCard,$email);
    }
    else {
        // Nessun record trovato con questo guid
        header_remove('Set-Cookie');
        // Il token JWT è presente, restituiscilo con header 200 OK
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'scontrino già presente con  codice: '.$codBill.' e matricola: '.$matricola],JSON_UNESCAPED_UNICODE);
        exit;
    }
        
    $response = array(
        'uid' => $fidelity->guid_webapp_c,
        'operazione' => 1
    );

    header_remove('Set-Cookie');
    // Il token JWT è presente, restituiscilo con header 200 OK
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(200);
    echo json_encode($response);
    exit;
} else {
    // Nessun record trovato con questo guid
    header_remove('Set-Cookie');
    // Il token JWT è presente, restituiscilo con header 200 OK
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(400);
    echo json_encode(['message' => 'Nessuna FidelityCard trovata con questo uid'],JSON_UNESCAPED_UNICODE);
    exit;
}
?>