<?php
global $db;
try{
    // Validazione presenza parametro
    $uid=$BeanUser->qrcode_c;
    //  Validazione presenza codice
    if (!isset($body['data']['attributes']['codice'])) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode([
            'message' => 'Parametro codice è obbligatorio',
        ]);
        exit;
    }

    //  Validazione presenza matricola
    if (!isset($body['data']['attributes']['matricola'])) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode([
            'message' => 'Parametro matricola è obbligatorio',
        ]);
        exit;
    }


    // ottengo i dati del codice dello scontrino 
    $codice = trim($body['data']['attributes']['codice']);
    // ottengo i dati della matricola 
    $matricola = trim($body['data']['attributes']['matricola']);

    // verifico se $uid non è vuoto
    if(empty($uid)){
        // se $uid è vuoto, restituisco un errore 400 Bad Request
        header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'uid non presente']);
        exit;
    }

    // verifico se $codice non è vuoto

    if(empty($codice)){
        // se $codice è vuoto, restituisco un errore 400 Bad Request
        header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'codice non presente']);
        exit;
    }

    // verifico se $matricola non è vuota

    if(empty($matricola)){
        // se $matricola è vuota, restituisco un errore 400 Bad Request
        header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' =>'matricola non presente']);
        exit;
    }

    // ottengo i dati della fidelity legati al guid
    // Cerco tra tutti i record del Bean FC_FidelityCard se il valore del uid è presente nel campo custom 'guid_webapp_c'
    $bean = BeanFactory::getBean('FC_FidelityCard');

    if (!$bean) {
        throw new Exception('Impossibile inizializzare il bean FC_FidelityCard');
    }

   // Metodo sicuro usando retrieve_by_string_fields
    $fidelityCard = $bean->retrieve_by_string_fields(array(
        'guid_webapp_c' => $uid,
        'deleted' => 0
    ));

    if ($fidelityCard && !empty($fidelityCard->id)) {
        // il guid è stato trovato in un record FC_FidelityCard
        // recupero i dati della fidelity
        $beanFidelityCard = $fidelityCard;
        // recupero il record del modulo CRF_crediti_fidelity
        $beanCrfCreditiFidelity = BeanFactory::getBean('CRF_crediti_fidelity');

        if (!$beanCrfCreditiFidelity) {
            throw new Exception('Impossibile inizializzare il bean CRF_crediti_fidelity');
        }

        
        //  Metodo sicuro usando retrieve_by_string_fields
        $creditoFidelity = $beanCrfCreditiFidelity->retrieve_by_string_fields(array(
            'codscontrino_c' => $codice,
            'matricola_c' => $matricola,
            'deleted' => 0
        ));

        $scontrino = "";

        if ($creditoFidelity && !empty($creditoFidelity->id)) {
            // recupero i dati dello scontrino dal campo jsonscontrino_c
            $scontrino = $creditoFidelity->jsonscontrino_c ?? '';

            // verifico se il scontrino è presente
            if(empty($scontrino)){
                // se il scontrino non è presente, restituisco un errore 404 Not Found
                header_remove('Set-Cookie');
                
                header('Content-Type: application/json; charset=utf-8');
                http_response_code(404);
                echo json_encode(['message' => 'Nessun scontrino trovato con questo codice e matricola']);
                exit;
            }
            else{
                header_remove('Set-Cookie');
                
                header('Content-Type: application/json; charset=utf-8');
                http_response_code(200);
                // Decodifica le entità HTML nel JSON
                $scontrino_decoded = html_entity_decode($scontrino);
                
                // Verifica che sia un JSON valido
                $json_check = json_decode($scontrino_decoded);
                if (json_last_error() === JSON_ERROR_NONE) {
                    // È un JSON valido, lo restituisco
                    echo $scontrino_decoded;
                } else {
                    // Non è un JSON valido, provo a sistemarlo
                    $scontrino_fixed = str_replace('&quot;', '"', $scontrino);
                    echo $scontrino_fixed;
                }
                exit;
            }    
        } else {
        // se lo scontrino non è presente, restituisco un errore 404 Not Found
                header_remove('Set-Cookie');
                
                header('Content-Type: application/json; charset=utf-8');
                http_response_code(400);
                echo json_encode(['message' => 'Nessun scontrino trovato con questo codice e matricola']);
                exit;
        }
        
    } else {
        // Nessun record trovato con questo guid
        header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Nessuna FidelityCard trovata con questo uid']);
        exit;
    }
} catch (Exception $e) {
    header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(500);
        echo json_encode(['message' => 'Errore critico recupero scontrino: ' . $e->getMessage()]);
        exit;
}
?>