<?php 
try{
    $uid="";
    // Validazione presenza parametro
    if (!isset($body['data']['attributes']['uid'])) {
        $uid=$BeanUser->qrcode_c;
    }
    else{
        // ottengo l'id della fidelity legato al guid 
        $uid = trim($body['data']['attributes']['uid']);
    }
    

    if (!isset($body['data']['attributes']['msg'])) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode([
            'message' => 'Parametro msg è obbligatorio', 
        ]);
        exit;
    }

    // ✅ CORREZIONE CRITICA: Definisco la variabile $message
    $message = trim($body['data']['attributes']['msg']);

    // verifico se $uid non è vuoto
    if(empty($uid)){
        // se $uid è vuoto, restituisco un errore 400 Bad Request
        // Nessun record trovato con questo guid
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'uid non presente']);
        exit;
    }

    if (empty($message)) {
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'messaggio non presente']);
        exit;
    }

    // ottengo i dati della fidelity legati al guid
    // Cerco tra tutti i record del Bean FC_FidelityCard se il valore del uid è presente nel campo custom 'guid_webapp_c'
    $bean = BeanFactory::getBean('FC_FidelityCard');

    if (!$bean) {
        throw new Exception('Impossibile inizializzare il bean FC_FidelityCard');
    }

   // Metodo sicuro usando retrieve_by_string_fields
    $fidelityCard = $bean->retrieve_by_string_fields(array(
        'guid_webapp_c' => $uid,
        'deleted' => 0
    ));

    if ($fidelityCard && !empty($fidelityCard->id)) {
        // titolo
        $task_title = "Assistenza utente FidelityCard";
        // nota
        $nota = "Richiesta assistenza per La fidelityCard con Guid: \n\n" . 
                htmlspecialchars($uid, ENT_QUOTES, 'UTF-8') . "\n\n" . 
                htmlspecialchars($message, ENT_QUOTES, 'UTF-8');
        // tipo utente destinatario
        $assignedType = "UserBackoffice";
        createAvvisoTask($task_title, $nota, $assignedType);

        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(200);
        echo json_encode(['message' => 'ok']);
        exit;
    } else {
        // Nessun record trovato con questo guid
        header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Nessuna FidelityCard trovata con questo uid']);
        exit;
    }
} catch (Exception $e) {
    header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(500);
        echo json_encode(['message' => 'Errore critico invia_ticket: ' . $e->getMessage()]);
        exit;
}    
?>