<?php
global $db;
try{
    // Validazione presenza parametro
    $uid=$BeanUser->qrcode_c;

    // verifico se $uid non è vuoto
    if(empty($uid)){
        // se $uid è vuoto, restituisco un errore 400 Bad Request
        header_remove('Set-Cookie');
        // Il token JWT è presente, restituiscilo con header 200 OK
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'uid non può essere vuoto']);
        exit;
    }

    // ottengo i dati della fidelity legati al guid
    // Cerco tra tutti i record del Bean FC_FidelityCard se il valore del uid è presente nel campo custom 'guid_webapp_c'
    $bean = BeanFactory::getBean('FC_FidelityCard');

    if (!$bean) {
        throw new Exception('Impossibile inizializzare il bean FC_FidelityCard');
    }

   // Metodo sicuro usando retrieve_by_string_fields
    $fidelityCard = $bean->retrieve_by_string_fields(array(
        'guid_webapp_c' => $uid,
        'deleted' => 0
    ));

    if ($fidelityCard && !empty($fidelityCard->id)) {
        // FidelityCard trovata usando il metodo sicuro
        $beanFidelityCard = $fidelityCard;
        
        $beanFidelityCard->load_relationship('ffd_fascefidelity_fc_fidelitycard_1');
        $relatedFasciaIds = $beanFidelityCard->ffd_fascefidelity_fc_fidelitycard_1->get();
        if (!empty($relatedFasciaIds)) {
            $fasciaId = reset($relatedFasciaIds); // Prende il primo ID dall'array
            $beanFascia = BeanFactory::getBean('FFD_FasceFidelity', $fasciaId);

            if($beanFascia){
                $fascia = $beanFascia->name;
            }
            else {
                $fascia = 'Nessuna fascia collegata';
            }
        } else {
            $fascia = 'Nessuna fascia collegata';
        }
        $dataFidelity = array(
            'displayName' => html_entity_decode($beanFidelityCard->first_name, ENT_QUOTES, 'UTF-8') ?? '',
            'allineata' => $beanFidelityCard->inetos_c ?? false,
            'vecchio_cliente' => $beanFidelityCard->vecchio_cliente_c ?? false,
            'oldId' => $beanFidelityCard->oldid_c ?? '',
            'points' => (int)($beanFidelityCard->punteggio_totale_c ?? 0),
            'fascia' => $fascia,
            'phone' => $beanFidelityCard->phone_home ?? '',
            'dataNascita' => !empty($beanFidelityCard->data_nascita_c) ? date('d-m-Y', strtotime($beanFidelityCard->data_nascita_c)) : '',
            'email' => $beanFidelityCard->indmail_c ?? '',
            'consenso1'=> (int)($beanFidelityCard->consenso1_c ?? 0),
            'consenso2'=> (int)($beanFidelityCard->consenso2_c ?? 0),
        );
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(200);
        echo json_encode($dataFidelity);
        exit;
    } else {
        // Nessun record trovato con questo guid
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Nessuna FidelityCard trovata con questo uid']);
        exit;
    }
} catch (Exception $e) {
    header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(500);
        echo json_encode(['message' => 'Errore critico dati fidelity: ' . $e->getMessage()]);
        exit;
}    
?>