<?php
global $db;
// ottengo l'id della fidelity legato al guid
try{
    // Validazione presenza parametro
    $uid=$BeanUser->qrcode_c;

    // verifico se $uid non è vuoto
    if(empty($uid)){
        // se $uid è vuoto, restituisco un errore 400 Bad Request
        header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'uid non presente']);
        exit;
    }

    if(isset($tknPush)) {
        // salvo il token per le notifiche push se non presente in relazione alla fidelity card
        creaTokenNotificationPush($uid,$tknPush);
        //write_to_log(array(), 'crediti fidelity token push: '. $tknPush);
    }

    // ottengo i dati della fidelity legati al guid
    // Cerco tra tutti i record del Bean FC_FidelityCard se il valore del uid è presente nel campo custom 'guid_webapp_c'
    $bean = BeanFactory::getBean('FC_FidelityCard');

    if (!$bean) {
        throw new Exception('Impossibile inizializzare il bean FC_FidelityCard');
    }

   // Metodo sicuro usando retrieve_by_string_fields
    $fidelityCard = $bean->retrieve_by_string_fields(array(
        'guid_webapp_c' => $uid,
        'deleted' => 0
    ));

    if ($fidelityCard && !empty($fidelityCard->id)) {
        // il guid è stato trovato in un record FC_FidelityCard
        // recupero i dati della fidelity
        $beanFidelityCard = $fidelityCard;
        
        // ottengo la lista dei crediti fidelity legati alla fidelity
        $creditiFidelity = $beanFidelityCard->get_linked_beans(
                'fc_fidelitycard_crf_crediti_fidelity_1',
                'CRF_crediti_fidelity',
                'date_entered DESC'
                );
        
        $dataFidelity = array();
        foreach ($creditiFidelity as $crediti) {
            $dataFidelity[] = array(
                'codscontrino' => $crediti->codscontrino_c,
                'matricola' => $crediti->matricola_c,
                'data_inserimento' => !empty($crediti->date_entered) ? date('d-m-Y H:i:s', strtotime($crediti->date_entered)) : '',
                'punteggio' => $crediti->punteggio_c
            );
        }
        header_remove('Set-Cookie');
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(200);
        echo json_encode($dataFidelity);
        exit;
    } else {
        // Nessun record trovato con questo guid
        header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'Nessuna FidelityCard trovata con questo uid']);
        exit;
    }
} catch (Exception $e) {
    header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(500);
        echo json_encode(['message' => 'Errore critico crediti fidelity: ' . $e->getMessage()]);
        exit;
}  
?>