<?php
// ottengo l'id della fidelity legato al guid 
$uid = $body['data']['attributes']['uid'];

// verifico se $uid non è vuoto
if(empty($uid)){
    header_remove('Set-Cookie');
    // Il token JWT è presente, restituiscilo con header 200 OK
    header('Content-Type: application/json; charset=utf-8');
    // se $uid è vuoto, restituisco un errore 400 Bad Request
    http_response_code(400);
    echo json_encode(['message' => 'uid non presente']);
    exit;
}

// mi salvo lo uid nel record xApi 
$BeanXapi = BeanFactory::getBean('xa_xApi', $xApiId);
$BeanXapi->description = $uid;
$BeanXapi->save();

// ottengo i dati della fidelity legati al guid
// Cerco tra tutti i record del Bean FC_FidelityCard se il valore del uid è presente nel campo custom 'guid_webapp_c'
$bean = BeanFactory::getBean('FC_FidelityCard');

// Sanitizzazione dell'input per prevenire SQL injection
$sanitized_uid = addslashes($uid);

$beanList = $bean->get_list(
    'first_name',
    "guid_webapp_c = '$sanitized_uid'",
    0,
    -1
);

if (!empty($beanList['list'])) {
    // il guid è stato trovato in un record FC_FidelityCard
    // recupero i dati della fidelity
    $fidelity = $beanList['list'][0];
    
    $beanFidelityCard = BeanFactory::getBean('FC_FidelityCard', $fidelity->id);
    $beanFidelityCard->inetos_c = 1;
    $beanFidelityCard->save();
    
    $response = array(
        'uid' => $fidelity->guid_webapp_c,
        'allineata' => 1
    );
    header_remove('Set-Cookie');
    // Il token JWT è presente, restituiscilo con header 200 OK
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(200);
    echo json_encode($response);
    exit;
} else {
    // Nessun record trovato con questo guid
    header_remove('Set-Cookie');
    // Il token JWT è presente, restituiscilo con header 200 OK
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(404);
    echo json_encode(['message' => 'Nessuna FidelityCard trovata con questo uid']);
    exit;
}
?>