<?php
// Assicura che il file non sia accessibile direttamente
if (!defined('sugarEntry')) {
    define('sugarEntry', true);
}

// --- IMPOSTAZIONI DI SICUREZZA ---
// Per evitare abusi, è FONDAMENTALE aggiungere un token di sicurezza.
// La tua webapp dovrà passare questo token per ottenere l'immagine.
/*
$valid_token = 'IL_TUO_TOKEN_SEGRETO_MOLTO_LUNGO'; // Cambia questa stringa!
$request_token = isset($_REQUEST['token']) ? $_REQUEST['token'] : '';

if ($request_token !== $valid_token) {
    header('HTTP/1.0 403 Forbidden');
    die('Accesso negato.');
}
*/
// --- LOGICA DI RECUPERO FILE ---
// Recupera i parametri dall'URL
$record_id = isset($_REQUEST['id']) ? $_REQUEST['id'] : null;
$file_name = isset($_REQUEST['file'])? $_REQUEST['file'] : "img.jpg";
$target_w = isset($_REQUEST['w']) ? (int)$_REQUEST['w'] : null;
$target_h = isset($_REQUEST['h']) ? (int)$_REQUEST['h'] : null;

if (empty($record_id)) {
    header('HTTP/1.0 400 Bad Request');
    die('Parametri mancanti.');
}

// Pulisci gli input per sicurezza (prevenire directory traversal)
$record_id = basename($record_id);

$field_name = "immagine_c";

// Costruisci il percorso del file come hai descritto
$file_path = 'upload/' . $record_id . '_' . $field_name;

if (file_exists($file_path)) {
    // Se non sono specificate dimensioni, servi il file originale
    if (!$target_w && !$target_h) {
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mime_type = finfo_file($finfo, $file_path);
        finfo_close($finfo);

        // Servi il file originale
        header('Content-Type: ' . $mime_type);
        header('Content-Length: ' . filesize($file_path));
        header('Content-Disposition: attachment; filename="' . $file_name . '"');
        
        readfile($file_path);
        exit();
    }

    // --- LOGICA DI RIDIMENSIONAMENTO ---
    list($original_w, $original_h, $type) = getimagesize($file_path);

    if ($original_w === null) {
        // Non è un'immagine valida, servi il file così com'è
        readfile($file_path);
        exit();
    }

    // Calcola le nuove dimensioni mantenendo l'aspect ratio
    if ($target_w && !$target_h) {
        $ratio = $original_w / $original_h;
        $target_h = $target_w / $ratio;
    } elseif (!$target_w && $target_h) {
        $ratio = $original_h / $original_w;
        $target_w = $target_h / $ratio;
    }

    // Crea l'immagine sorgente in base al tipo
    $source_image = null;
    switch ($type) {
        case IMAGETYPE_JPEG:
            $source_image = imagecreatefromjpeg($file_path);
            break;
        case IMAGETYPE_PNG:
            $source_image = imagecreatefrompng($file_path);
            break;
        case IMAGETYPE_GIF:
            $source_image = imagecreatefromgif($file_path);
            break;
        default:
            // Tipo di immagine non supportato per il ridimensionamento, servi l'originale
            readfile($file_path);
            exit();
    }

    $resized_image = imagecreatetruecolor($target_w, $target_h);

    // Gestisce la trasparenza per PNG
    if ($type == IMAGETYPE_PNG) {
        imagealphablending($resized_image, false);
        imagesavealpha($resized_image, true);
    }

    imagecopyresampled($resized_image, $source_image, 0, 0, 0, 0, $target_w, $target_h, $original_w, $original_h);
    header('Content-Disposition: attachment; filename="' . $file_name . '"');

    // Invia l'header e l'immagine ridimensionata al browser
    switch ($type) {
        case IMAGETYPE_JPEG:
            header('Content-Type: image/jpeg');
            imagejpeg($resized_image, null, 90); // Output con qualità 90%
            break;
        case IMAGETYPE_PNG:
            header('Content-Type: image/png');
            imagepng($resized_image);
            break;
        case IMAGETYPE_GIF:
            header('Content-Type: image/gif');
            imagegif($resized_image);
            break;
    }

    imagedestroy($source_image);
    imagedestroy($resized_image);
    exit();

} else {
    header('HTTP/1.0 404 Not Found');
    die('Immagine non trovata.');
}