<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $sugar_config;
// ottengo gli headers HTTP inviati dal client
$headers = getallheaders();
// normalizzo gli headers 
$headers = array_change_key_case($headers, CASE_LOWER);
//********* FUNZIONI  *******/

// funzione per rinfrescare il token di autenticazione JWT
function refreshToken($rft) {
    global $sugar_config;
    // ottengo l'url di base dell'installazione SuiteCRM
    $base_url=$sugar_config['site_url'];

    $myCurl=new MyHgFunction($base_url.'/Api/access_token');

    $body_check=array(
      "grant_type"=>"refresh_token",
      "client_id" => $sugar_config['oauth_app_client_id'],
      "client_secret" => $sugar_config['oauth_app_client_secret'],
      "refresh_token" => $rft 
    );

    $json_check=json_encode( $body_check );

    ob_start();
    try{
        $header_check=array(
        'Content-Type: application/json'
        );

        $myCurl->setHeader($header_check);

        $result = $myCurl->myCall($json_check, 'POST');

        // Decodifica il risultato JSON
        $response = json_decode($result, true);

        // Verifica se il token è presente nella risposta
        if (isset($response['access_token'])) {
            // Rimuovi tutti i cookie impostati
            header_remove('Set-Cookie');
            // Il token JWT è presente, restituiscilo con header 200 OK
            header('Content-Type: application/json; charset=utf-8');
            // Il token JWT è presente, restituiscilo con header 200 OK
            http_response_code(200);
            echo $result;
        } else {
            // Il token JWT non è presente, restituisci un errore 400 Bad Request
            // Rimuovi tutti i cookie impostati
            header_remove('Set-Cookie');
            // Il token JWT è presente, restituiscilo con header 200 OK
            header('Content-Type: application/json; charset=utf-8');
            http_response_code(401);
            echo json_encode(['message' => 'Refresh Token non valido']);
        }
    } catch (Exception $e) {
        // Rimuovi tutti i cookie impostati
        header_remove('Set-Cookie');
        // Il token JWT è presente, restituiscilo con header 200 OK
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(500);
        echo json_encode(array('message' => 'Error refreshing token: '.$e->getMessage()));
    }
    exit;
}


/*** fine delle funzioni ***/

// verifico se presente la chiave 'refresh_token' nel header

if(isset($headers['refresh-token'])) {
    // recupero il refresh token
    $rft = $headers['refresh-token'];

    // eseguo la funzione per rinfrescare il token
    refreshToken($rft);
} else {
    // Rimuovi tutti i cookie impostati
    header_remove('Set-Cookie');
    // Il token JWT è presente, restituiscilo con header 200 OK
    header('Content-Type: application/json; charset=utf-8');
    // chiave 'refresh_token' non presente nel header, restituisco un errore 401 Unauthorized
    http_response_code(401);
    echo json_encode(array('message' => 'Unauthorized: Missing refresh token in header'));
    exit;
}