<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
require_once('include/SugarPHPMailer.php');
require_once('include/database/DBManagerFactory.php');
require_once('include/utils.php');
require_once('modules/Emails/Email.php');
use Kreait\Firebase\Factory;
use Kreait\Firebase\Exception\Auth\UserNotFound;
global $sugar_config;
// ottengo gli headers HTTP inviati dal client
$headers = getallheaders();
//write_to_log($headers, "Request getAccess headers: ");
// normalizzo gli headers 
$headers = array_change_key_case($headers, CASE_LOWER);
//write_to_log($headers, "Request getAccess headers lower: ");

//********* FUNZIONI  *******/
// funzione per verificare il validità dello UID del qrcode
// TODO: implementare la validazione dello UID in FIREBASE
function validateUID($uid) {
    global $sugar_config;
    // implementare la validazione dello UID in FIREBASE
    $pathKey = $sugar_config['path_key_firebase'];
    $factory = (new Factory)->withServiceAccount($pathKey);

    // Inizializza il servizio Authentication
    $auth = $factory->createAuth();
   
    try {
        // Ottieni i dati dell'utente
        $response = $auth->getUser($uid); 
        //$response = $user->jsonSerialize();
    } catch (UserNotFound $e) {
        $response = null;
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(404);
        echo json_encode(['error' => 'UID non trovato in Firebase']);
        exit;
        
    } catch (\Exception $e) {
        $response = null;
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(500);
        echo json_encode(['error' => 'Errore nel verificare UID in Firebase', 'message' => $e->getMessage()]);
        exit;
    }
    return $response;
}

// funzione gestione qrcode non presente nel header
function handleMissingUid() {
    // codice specifico per gestione qrcode non presente nel header
    // esempio: ritorno un header HTTP 400
    // Rimuovi tutti i cookie impostati
    header_remove('Set-Cookie');
    // Il token JWT è presente, restituiscilo con header 200 OK
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(400);
    echo json_encode(array('message' => 'Missing UID in header'));
    exit;
}

// funzione gestione qrcode non valido
function handleInvalidUid() {
    // codice specifico per gestione qrcode non valido
    // esempio: ritorno un header HTTP 400
    // Rimuovi tutti i cookie impostati
    header_remove('Set-Cookie');
    // Il token JWT è presente, restituiscilo con header 200 OK
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(422);
    echo json_encode(array('message' => 'bad request Invalid Uid'));
    exit;
}

// funzione per recuperare il token di autenticazione JWT
function getToken($user) {
    try{
        global $sugar_config;
        // codice specifico per recuperare il token JWT
        // esempio: recuperare il token JWT dal database o utilizzando un servizio di autenticazione
        // TODO: implementare il recupero del token JWT
        
        // ottengo l'url di base dell'installazione SuiteCRM
        $base_url=$sugar_config['site_url'];

        $myCurl=new MyHgFunction($base_url.'/Api/access_token');

        $body_check=array(
        "grant_type"=>"password",
        "client_id" => $sugar_config['oauth_app_client_id'],
        "client_secret" => $sugar_config['oauth_app_client_secret'],
        "username" => $user->user_name,
        "password" => $sugar_config['pwdNewUsrFidelity']
        );

        $json_check=json_encode( $body_check );

        //write_to_log(array(),'DEBUG json_check');

        $header_check=array(
        'Content-Type: application/json',
        'Content-Length: ' . strlen($json_check)
        );

        $myCurl->setHeader($header_check);

        $result = $myCurl->myCall($json_check, 'POST');
        
        // Decodifica il risultato JSON
        $response = json_decode($result, true);

        // Verifica se il token è presente nella risposta
        if (isset($response['access_token'])) {
            // Rimuovi tutti i cookie impostati
            header_remove('Set-Cookie');
            // Il token JWT è presente, restituiscilo con header 200 OK
            header('Content-Type: application/json; charset=utf-8');
            http_response_code(200);
            //write_to_log(array(),'result: '.$result);        
            echo $result;
        } else {
            // Rimuovi tutti i cookie impostati
            header_remove('Set-Cookie');
            // Il token JWT è presente, restituiscilo con header 200 OK
            header('Content-Type: application/json; charset=utf-8');
            // Il token JWT non è presente, restituisci un errore 400 Bad Request
            http_response_code(401);
            echo json_encode(['error' => 'Token non trovato nella risposta']);
        }
    } catch (Exception $e) {
        // Rimuovi tutti i cookie impostati
            header_remove('Set-Cookie');
            // Il token JWT è presente, restituiscilo con header 200 OK
            header('Content-Type: application/json; charset=utf-8');
            // Il token JWT non è presente, restituisci un errore 400 Bad Request
            http_response_code(500);
            echo json_encode(['error' => 'Errore interno nella generazione del token: '. $e->getMessage()]);
    }    
    exit;
}

// funzione per inviare una mail utilizzando il template
function sendEmailUsingTemplate($user,$emailContatto,$userNameMail){
    global $current_user, $sugar_config;
    // ID del template email
    $template_id = 'bcdf3d0b-3343-110a-96b6-6749de6fba73';
    ob_start();
    try{
        // Recupera il template email
        $emailTemplate = BeanFactory::getBean('EmailTemplates', $template_id);
        if (!empty($emailTemplate->id)) {
            $toEmail = $user->user_name;
            $userName = $userNameMail;
            if($emailContatto!= ''){
                $toEmail = $emailContatto;
            }
            if($userName== ''){
                $userName = $user->user_name;
            }

            // Prepara il corpo dell'email sostituendo le variabili
            $html_head='<html><head></head><body>';
            $html_footer='</body></html>';
            $body_html = $emailTemplate->body_html;
            
            $body_plain = $emailTemplate->body;
            $body_html = str_replace('$contact_user_user_name', $userName, $body_html);       
            // Configura e invia l'email
            $mailer = new SugarPHPMailer();
            $mailer->setMailerForSystem();
            $mailer->From = "crm.notifiche@helinext.it";
            $mailer->FromName = "Notifiche";
            $mailer->Subject = $emailTemplate->subject;
            $mailer->isHTML(true);
            $body_html = $html_head. $body_html. $html_footer;
            
            // Decodifica le entità HTML
            $body_html = html_entity_decode($body_html, ENT_QUOTES | ENT_HTML5, 'UTF-8');

            $mailer->Body = $body_html;
            $mailer->AltBody = $body_plain;

            // Imposta esplicitamente il charset
            $mailer->CharSet = 'UTF-8';
            
            //$mailer->Encoding = 'base64';
            //$mailer->CharSet = 'UTF-8';
            $mailer->AddAddress($toEmail);
            
            // Invia l'email
            if ($mailer->Send()) {
                $GLOBALS['log']->info('Email inviata con successo a: ' . $toEmail);
                // tengo traccia della mail inviata sul DB
                // Crea e invia l'email
                $email = new Email();
                $email->name = $emailTemplate->subject;
                $email->type = 'out';
                $email->status = 'sent';  // Cambiato da 'sent' a 'draft'
                $email->parent_type = 'Users';
                $email->parent_id = $user->id;                       
                $email->subject = $emailTemplate->subject;
                // Salva il record dell'email inviata
                $email->save();

                // Crea il record nella tabella emails_text usando SQL diretto
                
                global $db;
                $query = "UPDATE emails_text
                SET from_addr='crm.notifiche@helinext.it',
                 to_addrs='".$toEmail."',
                  emails_text.description='".addslashes($body_plain)."',
                   description_html='".addslashes(from_html($body_html))."'
                WHERE email_id='".$email->id."'";
                                
                try {
                    $result = $db->query($query);
                    
                    if ($result) {
                        $GLOBALS['log']->info('Record EmailText creato con successo per l\'email ID: ' . $email->id);
                    } else {
                        $GLOBALS['log']->error('Nessun record EmailText creato per l\'email ID: ' . $email->id);
                    }

                } catch (Exception $e) {
                    $GLOBALS['log']->error('Errore durante l\'inserimento del record EmailText: ' . $e->getMessage());
                }
                return true;
            } else {
                $GLOBALS['log']->error('Fallimento nell\'invio dell\'email a: ' . $toEmail . '. Errore: ' . $mailer->ErrorInfo);
                return false;
            }
        } else {
            $GLOBALS['log']->error('Template email non trovato: ' . $template_id);
            return false;
        }
    }
    catch(Exception $e){
        // non faccio nulla per non bloccare il proseguo del codice
        //write_to_log(array(),'ERROR: '.$e->getMessage());
        $GLOBALS['log']->fatal('Errore nell\'invio dell\'email: ' . $e->getMessage());
    }
    finally {
        ob_end_clean(); // Questo pulirà qualsiasi output generato
    }
    
}


/*********** fine funzioni  ***********/
try{
// verifico se presente la chiave 'qrcode' nel header
    if(isset($headers['uid'])) {
        // recupero il uid dal header
        $uid = $headers['uid'];

        // verifico se il uid è valido su FIREBASE
        $firebaseUser=validateUID($uid);
        //write_to_log($firebaseUser,'debug: ');
        // se il uid è valido, recupero i dati utente
        if($firebaseUser!=null && $firebaseUser->uid==$uid){ 
            // Cerco tra tutti i record del Bean Users se il valore del uid è presente nel campo custom 'uid_c'
            $bean = BeanFactory::getBean('Users');
            $beanList=$bean->get_list(
                'user_name',
                "qrcode_c = '$uid'",
                0,
                -1
            );

            // Cerco tra tutti i record del Bean FC_FidelityCard se il valore del uid è presente nel campo custom 'guid_webapp_c'
            $beanFidelity = BeanFactory::getBean('FC_FidelityCard');

            if (!$beanFidelity) {
                throw new Exception('Impossibile inizializzare il bean FC_FidelityCard');
            }

            // Metodo sicuro usando retrieve_by_string_fields
            $fidelityCard = $beanFidelity->retrieve_by_string_fields(array(
                'guid_webapp_c' => $uid,
                'deleted' => 0
            ));

            

            if ($fidelityCard && !empty($fidelityCard->id)) {
                $emailContatto = $fidelityCard->indmail_c;
                $userNameMail = $fidelityCard->first_name;
                //write_to_log(array(),'debug: emailContatto '.$emailContatto.' userNameMail '.$userNameMail);
            }
            else {
                $emailContatto = '';
                $userNameMail = '';
            }

                        
            if (!empty($beanList['list'])) {
                // Il uid è stato trovato in un record Users
                // utente già registrato
                $user = $beanList['list'][0];
                // verifico se lo username è un indirizzo email per inviare la notifica mail
                if (preg_match('/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/', $user->user_name)) {
                    // avviso mandando una mail a utente
                    sendEmailUsingTemplate($user, $emailContatto, $userNameMail);
                }
                //echo json_encode(array('message' => 'uid valido', 'user_id' => $user->id, 'user_name' => $user->user_name));
                
                getToken($user);
                exit;
            } else {
                // Il uid non è stato trovato in nessun record Users
                // recupero la password standard dell'utente fidelity
                
                $standardPassword = $sugar_config['pwdNewUsrFidelity'];
                
                // TODO: il nome sarà recuperato da FIREBASE
                // mettere nello username la mail recuperata da FIREBASE se presente altrimenti 
                $fMail="";
                $fTel="";
                $fDisplayName="";
                // se il campo 'email' è presente e non è vuoto recupero la mail
                if(isset($firebaseUser->email) &&!empty($firebaseUser->email))
                    $fMail=$firebaseUser->email;
                // se il campo 'phone_number' è presente e non è vuoto recupero il numero di telefono
                if(isset($firebaseUser->phoneNumber) &&!empty($firebaseUser->phoneNumber))
                    $fTel=$firebaseUser->phoneNumber;
                
                // se il campo email è presente e non è vuoto recupero la mail altrimenti il numero di telefono 
                // per lo user name dell'utente creato in SuiteCRM

                $username=$fMail;
                if(empty($username))
                    $username=$fTel;

                // se il campo 'display_name' è presente e non è vuoto recupero il nome visualizzato
                // altrimenti utilizzo lo username precedentemente creato in SuiteCRM
                if(isset($firebaseUser->displayName) &&!empty($firebaseUser->displayName))
                    $fDisplayName=$firebaseUser->displayName;
                else
                    $fDisplayName=$username;
                                    
                // creo un nuovo record Users
                $user = BeanFactory::newBean('Users');
                $user->user_name = $username;
                $user->user_hash = User::getPasswordHash($standardPassword);
                $user->qrcode_c = $uid;
                $user->status = 'Active';
                $user->is_admin = 0;  // Non amministratore
                //$user->external_auth_only = 0;
                $user->sugar_login = 1;
                
                $user->save();

                // Assegna il ruolo 'Fidelity' al nuovo account
                
                $user->load_relationship('aclroles');
                $user->aclroles->add('10a1a386-ae0a-bcbc-687a-67376a363ff8');

                $user->save();

                // creo un record per il modulo FC_FidelityCard e ci passo i dati recuperati da FIREBASE
                $beanFidelityCard = BeanFactory::newBean('FC_FidelityCard');
                $beanFidelityCard->first_name = $fDisplayName;
                $beanFidelityCard->guid_webapp_c = $uid;
                
                $beanFidelityCard->phone_home = $fTel;
                //$beanFidelityCard->tipologia_carta_c = "BASE";
                $beanFidelityCard->punteggio_totale_c=0;

                $beanFidelityCard->save();

                // collego il record FC_FidelityCard al nuovo record Users usando la relazione one to one users_fc_fidelitycard_1
                $user->load_relationship('users_fc_fidelitycard_1');
                $user->users_fc_fidelitycard_1->add($beanFidelityCard->id);
                $user->save();

                // collego il record FC_FidelityCard alla sua soglia di fidelity del modulo Fasce Fidelity - FFD_FasceFidelity - passando alla funzione il punteggio 0
                $fascia=assegnaFascieFidelity($beanFidelityCard, 0);
                $beanFidelityCard->tipologia_carta_c = $fascia;
                $beanFidelityCard->save();

                // creo un record per l'indirizzo email primario e lo associo al nuovo record FC_FidelityCard se lo user name dell'utente è un indirizzo email
                if (preg_match('/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/', $user->user_name)) {
                    $beanEmail = new SugarEmailAddress; 
                    $beanEmail->addAddress($username, true); 
                    $beanEmail->save($beanFidelityCard->id, "FC_FidelityCard");
                }
                
                        

                if (!empty($user->id)) {
                    // TODO CREO nuovo record in ETOS
                    creaRecordInETOS($beanFidelityCard,$username);
                    
                    getToken($user);
                } else {
                    // Rimuovi tutti i cookie impostati
                    header_remove('Set-Cookie');
                    // Il token JWT è presente, restituiscilo con header 200 OK
                    header('Content-Type: application/json; charset=utf-8');
                    http_response_code(500);
                    echo json_encode(array('message' => 'Errore interno nella creazione dell\'utente'));
                }
                
                exit;
                
            }
            
        
        } else {
            // codice per gestione qrcode non valido
            handleInvalidUid();
        }
    } else {
        // codice per gestione qrcode non presente nel header
        handleMissingUid();
    }
} catch (Exception $e) {
    // Rimuovi tutti i cookie impostati
    header_remove('Set-Cookie');
    // Il token JWT è presente, restituiscilo con header 200 OK
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(500);
    echo json_encode(array('message' => 'Errore critico: ' . $e->getMessage()));
}
