<?php 
 //WARNING: The contents of this file are auto-generated


$job_strings[] = 'jobPushNotify';

use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;

// Inizializza l'applicazione
global $current_user, $sugar_config, $db;
$current_user = BeanFactory::newBean('Users');
$current_user->getSystemUser();


// ******** FUNZIONI ********//
function getTokenArray(){
    global $db;
    $tokenList = array();
    $query="
        SELECT fcc.guid_webapp_c,tnp.name
FROM fc_fidelitycard fc
INNER JOIN fc_fidelitycard_cstm fcc
	ON fc.id = fcc.id_c
	INNER JOIN fc_fidelitycard_tnp_tokennotificationpush_1_c fctp
		ON fc.id =  fctp.fc_fidelitycard_tnp_tokennotificationpush_1fc_fidelitycard_ida
		INNER JOIN tnp_tokennotificationpush tnp
			ON fctp.fc_fidelite3d1ionpush_idb = tnp.id
WHERE tnp.deleted = 0
    ";
    $result = $db->query($query);
    while ($row = $db->fetchRow($result)) {
        //echo "guid_webapp_c: ". $row['guid_webapp_c']. ", Nome TokenNotificationPush: ". $row['name']. "\n";
        $tokenList[] = $row['name'];
    }
    return $tokenList;
}

function sendPushNotification($tokens, $titolo, $messaggio) {
    
    // Inizializza l'applicazione
    global $sugar_config;

    $titolo = html_entity_decode($titolo ?? '', ENT_QUOTES | ENT_HTML5, 'UTF-8');
    $messaggio = html_entity_decode($messaggio ?? '', ENT_QUOTES | ENT_HTML5, 'UTF-8');

    // Assicurati che ci siano token a cui inviare
    if (empty($tokens)) {
        $GLOBALS['log']->info('sendPushNotification: Nessun token fornito per l\'invio.');
        
        return;
    }

     try {
        $pathKey = $sugar_config['path_key_firebase'];
        $factory = (new \Kreait\Firebase\Factory)->withServiceAccount($pathKey);
        $messaging = $factory->createMessaging();

        $message = \Kreait\Firebase\Messaging\CloudMessage::new()
        ->withNotification(\Kreait\Firebase\Messaging\Notification::create($titolo, $messaggio))
        ->withData(['click_action' => 'FLUTTER_NOTIFICATION_CLICK']); // Esempio di dato aggiuntivo

        // Suddividi i token in blocchi di 500 (limite di Firebase)
        $tokenChunks = array_chunk($tokens, 500);

        $totalSuccessfulSends = 0;
        $totalFailedSends = 0;
        $allFailures = [];

        foreach ($tokenChunks as $chunk) {
            /** @var Kreait\Firebase\Messaging\MulticastSendReport $sendReport */
            $sendReport = $messaging->sendMulticast($message, $chunk);

            $totalSuccessfulSends += $sendReport->successes()->count();
            $totalFailedSends += $sendReport->failures()->count();

            if ($sendReport->hasFailures()) {
                $allFailures = array_merge($allFailures, $sendReport->failures()->getItems());
            }
        }

        if ($totalSuccessfulSends > 0) {
            $GLOBALS['log']->info("Inviate con successo {$totalSuccessfulSends} notifiche push.");
        }

        if ($totalFailedSends > 0) {
            $GLOBALS['log']->error("Impossibile inviare {$totalFailedSends} notifiche push.");

            $tokensToDelete = [];
            // Log dei token falliti e del motivo
            foreach ($allFailures as $failure) {
                $reason = $failure->error()->getMessage();
                $invalidToken = $failure->target()->value();
                $GLOBALS['log']->error("Token fallito: " . $invalidToken . " - Motivo: " . $reason);

                // Se il token non è registrato o non è valido, aggiungilo alla lista per la cancellazione
                if($reason=='The registration token is not a valid FCM registration token' || $reason=='Invalid registration token' || $reason =='Requested entity was not found') {
                    $tokensToDelete[] = $invalidToken;
                }
    
            }


            // Cancella i token non validi dal database
            if (!empty($tokensToDelete)) {
                deleteInvalidTokens($tokensToDelete);
                //write_to_log($tokensToDelete, 'tokens_invalidi' );
            }
        }

    } catch (Exception $e) {
        $GLOBALS['log']->fatal('Errore critico durante l\'invio di notifiche push: ' . $e->getMessage());
        $task_title="ERRORE nel creare utente in ETOS";
        $nota = "Errore durante l'invio delle notifiche push aspetta 5 minuti e riprova.";
        $assignedType = "UserBackoffice";
        createAvvisoTask($task_title, $nota, $assignedType);
    }
}

// funzione per eliminare i token non validi dal database
function deleteInvalidTokens($tokensToDelete) {
    global $db;
    //write_to_log($tokensToDelete, 'tokens_invalidi' );
    $query = "UPDATE tnp_tokennotificationpush SET deleted = 1 WHERE name IN ('". implode("','", $tokensToDelete). "')";
    $db->query($query);
    $GLOBALS['log']->info("Token eliminati: ". implode(", ", $tokensToDelete));
}

//***** FINE FUNZIONI *****/

function jobPushNotify() {
    $GLOBALS['log']->info("Inizio jobPushNotify.");

    // Definisci la clausola WHERE per trovare i record con invianotifica_c = 1
    $where_clause = "invianotifica_c = 1";
    $tokensNotif = null; // Inizializza l'array di token per caricarlo una sola volta

    // 1. Gestione NEWS
    $newsBean = BeanFactory::newBean('NW_News');
    $result = $newsBean->get_list("date_entered DESC", $where_clause, 0, 1, -1, 0);

    if (!empty($result['list'])) {
        $newsRecord = $result['list'][0];
        $GLOBALS['log']->info("Trovata news da notificare con ID: " . $newsRecord->id . ", Titolo: " . $newsRecord->name);

        // Carica i token solo se necessario
        if ($tokensNotif === null) {
            $tokensNotif = getTokenArray();
        }

        if (!empty($tokensNotif)) {
            sendPushNotification($tokensNotif, $newsRecord->name, $newsRecord->description);

            // Aggiorna il record per non inviare più la notifica
            $newsRecord->invianotifica_c = 0;
            $newsRecord->save();
            $GLOBALS['log']->info("Flag invianotifica_c impostato a 0 per la news ID: " . $newsRecord->id);
        } else {
            $GLOBALS['log']->warning("Nessun token trovato per inviare la notifica della news ID: " . $newsRecord->id);
        }
    } else {
        $GLOBALS['log']->info("Nessuna nuova news da notificare.");
    }

    // 2. Gestione OFFERTE
    $promoBean = BeanFactory::newBean('OFF_Offerte');
    $promoResult = $promoBean->get_list("date_entered DESC", $where_clause, 0, 1, -1, 0);

    if (!empty($promoResult['list'])) {
        $promoRecord = $promoResult['list'][0];
        $GLOBALS['log']->info("Trovata offerta da notificare con ID: " . $promoRecord->id . ", Titolo: " . $promoRecord->name);

        // Carica i token solo se non già caricati
        if ($tokensNotif === null) {
            $tokensNotif = getTokenArray();
        }

        if (!empty($tokensNotif)) {
            sendPushNotification($tokensNotif, $promoRecord->name, $promoRecord->description);

            // Aggiorna il record per non inviare più la notifica
            $promoRecord->invianotifica_c = 0;
            $promoRecord->save();
            $GLOBALS['log']->info("Flag invianotifica_c impostato a 0 per l'offerta ID: " . $promoRecord->id);
        } else {
            $GLOBALS['log']->warning("Nessun token trovato per inviare la notifica dell'offerta ID: " . $promoRecord->id);
        }
    } else {
        $GLOBALS['log']->info("Nessuna nuova offerta da notificare.");
    }

    $GLOBALS['log']->info("Fine jobPushNotify.");
    return true;
}
?>