<?php
// Definisci il punto di ingresso
define('sugarEntry', TRUE);

// Imposta il percorso corrente alla directory principale di SuiteCRM
chdir('/var/www/html/modacenter');

// Includi il file di inizializzazione di SuiteCRM
require_once('include/entryPoint.php');
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;

// Inizializza l'applicazione
global $current_user, $sugar_config, $db;
$current_user = BeanFactory::newBean('Users');
$current_user->getSystemUser();

// ******** FUNZIONI ********//
function getTokenArray(){
    global $db;
    $tokenList = array();
    $query="
        SELECT fcc.guid_webapp_c,tnp.name
FROM fc_fidelitycard fc
INNER JOIN fc_fidelitycard_cstm fcc
	ON fc.id = fcc.id_c
	INNER JOIN fc_fidelitycard_tnp_tokennotificationpush_1_c fctp
		ON fc.id =  fctp.fc_fidelitycard_tnp_tokennotificationpush_1fc_fidelitycard_ida
		INNER JOIN tnp_tokennotificationpush tnp
			ON fctp.fc_fidelite3d1ionpush_idb = tnp.id
WHERE tnp.deleted = 0
    ";
    $result = $db->query($query);
    while ($row = $db->fetchRow($result)) {
        //echo "guid_webapp_c: ". $row['guid_webapp_c']. ", Nome TokenNotificationPush: ". $row['name']. "\n";
        $tokenList[] = $row['name'];
    }
    return $tokenList;
}

function sendPushNotification($tokens, $titolo, $messaggio) {
    
    // Inizializza l'applicazione
    global $sugar_config;

    // Assicurati che ci siano token a cui inviare
    if (empty($tokens)) {
        $GLOBALS['log']->info('sendPushNotification: Nessun token fornito per l\'invio.');
        
        return;
    }

    try {
        $pathKey = $sugar_config['path_key_firebase'];
        $factory = (new \Kreait\Firebase\Factory)->withServiceAccount($pathKey);
        $messaging = $factory->createMessaging();

        $message = \Kreait\Firebase\Messaging\CloudMessage::new()
        ->withNotification(\Kreait\Firebase\Messaging\Notification::create($titolo, $messaggio))
        ->withData(['click_action' => 'FLUTTER_NOTIFICATION_CLICK']); // Esempio di dato aggiuntivo

        // Suddividi i token in blocchi di 500 (limite di Firebase)
        $tokenChunks = array_chunk($tokens, 500);

        $totalSuccessfulSends = 0;
        $totalFailedSends = 0;
        $allFailures = [];

        foreach ($tokenChunks as $chunk) {
            /** @var Kreait\Firebase\Messaging\MulticastSendReport $sendReport */
            $sendReport = $messaging->sendMulticast($message, $chunk);

            $totalSuccessfulSends += $sendReport->successes()->count();
            $totalFailedSends += $sendReport->failures()->count();

            if ($sendReport->hasFailures()) {
                $allFailures = array_merge($allFailures, $sendReport->failures()->getItems());
            }
        }

        if ($totalSuccessfulSends > 0) {
            $GLOBALS['log']->info("Inviate con successo {$totalSuccessfulSends} notifiche push.");
        }

        if ($totalFailedSends > 0) {
            $GLOBALS['log']->error("Impossibile inviare {$totalFailedSends} notifiche push.");

            $tokensToDelete = [];
            // Log dei token falliti e del motivo
            foreach ($allFailures as $failure) {
                $reason = $failure->error()->getMessage();
                $invalidToken = $failure->target()->value();
                $GLOBALS['log']->error("Token fallito: " . $invalidToken . " - Motivo: " . $reason);

                // Se il token non è registrato o non è valido, aggiungilo alla lista per la cancellazione
                if($reason=='The registration token is not a valid FCM registration token' || $reason=='Invalid registration token' || $reason =='Requested entity was not found') {
                    $tokensToDelete[] = $invalidToken;
                }
    
            }


            // Cancella i token non validi dal database
            if (!empty($tokensToDelete)) {
                deleteInvalidTokens($tokensToDelete);
                //write_to_log($tokensToDelete, 'tokens_invalidi' );
            }
        }

    } catch (Exception $e) {
        $GLOBALS['log']->fatal('Errore critico durante l\'invio di notifiche push: ' . $e->getMessage());
        $task_title="ERRORE nel creare utente in ETOS";
        $nota = "Errore durante l'invio delle notifiche push aspetta 5 minuti e riprova.";
        $assignedType = "UserBackoffice";
        createAvvisoTask($task_title, $nota, $assignedType);
    }
}

// funzione per eliminare i token non validi dal database
function deleteInvalidTokens($tokensToDelete) {
    global $db;
    //write_to_log($tokensToDelete, 'tokens_invalidi' );
    $query = "UPDATE tnp_tokennotificationpush SET deleted = 1 WHERE name IN ('". implode("','", $tokensToDelete). "')";
    $db->query($query);
    $GLOBALS['log']->info("Token eliminati: ". implode(", ", $tokensToDelete));
}

//***** FINE FUNZIONI *****/
echo "\nAvvio il Job\n";

// Carica il bean del modulo NW_News
$newsBean = BeanFactory::newBean('NW_News');

// Definisci la clausola WHERE per trovare i record con invianotifica_c = 1
// Nota: i campi custom si trovano nella tabella _cstm
$where_clause = "invianotifica_c = 1";

// Utilizza get_list per recuperare il primo record che soddisfa la condizione
$result = $newsBean->get_list("date_entered DESC", $where_clause, 0, 1, -1, 0);

// Estrai il record dalla lista dei risultati
$newsRecord = null;
if (!empty($result['list'])) {
    $newsRecord = $result['list'][0];
}

// Controlla se è stato trovato un record
if ($newsRecord) {
    // Ora puoi lavorare con il record $newsRecord
    echo "Record trovato con ID: " . $newsRecord->id . "\n";
    echo "Titolo: " . $newsRecord->name . "\n";
    // per ogni record del modulo FC_FidelityCard stampo tutti i record del modulo TNP_TokenNotificationPush relazionati con la relazione fc_fidelitycard_tnp_tokennotificationpush_1
    $tokensNotif = getTokenArray();
    //var_dump($tokensNotif);
    sendPushNotification($tokensNotif, $newsRecord->name, $newsRecord->description);
} else {
    echo "Nessun record da elaborare trovato.\n";
}


// verifico le OFFERTE
// Carica il bean del modulo OFF_Offerte
$promoBean = BeanFactory::newBean('OFF_Offerte');

// Utilizza get_list per recuperare il primo record che soddisfa la condizione
$promoResult = $promoBean->get_list("date_entered DESC", $where_clause, 0, 1, -1, 0);

// Estrai il record dalla lista dei risultati
$promoRecord = null;
if (!empty($promoResult['list'])) {
    $promoRecord = $promoResult['list'][0];
}

// Controlla se è stato trovato un record
if ($promoRecord) {
    // Ora puoi lavorare con il record $promoRecord
    echo "Record trovato con ID: ". $promoRecord->id. "\n";
    echo "Titolo: ". $promoRecord->name. "\n";
    $tokensNotif = getTokenArray();
    //var_dump($tokensNotif);
    sendPushNotification($tokensNotif, $newsRecord->name, $newsRecord->description);
} else {
    echo "Nessun record da elaborare trovato.\n";
}



echo "Fine\n";
