<?php 
 //WARNING: The contents of this file are auto-generated


class MyHgFunction{
  // stringa url da utilizzare
  public $url;
  // array di stringhe per gli header
  public $header;
  // curl HENDLER
  public $ch;
  // costruttore
  public function __construct($url_call){
    $this->url=$url_call;
    $this->ch=curl_init();
  }

  // metodo per settare l'url
  public function setUrl($newUrl){
    $this->url=$newUrl;
  }
  // metodo per ottenere l'url attuale
  public function getUrl(){
    echo $this->url;
  }
  // metodo per settare l'header della chiamata cURL
  public function setHeader($newHeader){
    $this->header=$newHeader;
  }
  // metodo per ottenere l'header impostato
  public function getHeader(){
    return $this->header;
  }
  // metodo per verificare se l'header è stato impostato
  public function isHeader(){
    if(isset($this->header) && !empty($this->header))
      return true;
    else
      return false;
  }
  // metodo per effettuare la cURL
  //@payload -> json del body
  public function myCall($payload='',$method='GET', $curlopt_header=FALSE){
    // Prepare new cURL resource
    curl_setopt($this->ch, CURLOPT_URL, $this->url);
    curl_setopt($this->ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($this->ch, CURLINFO_HEADER_OUT, true);
    if($method=='POST'){
      curl_setopt($this->ch, CURLOPT_POST, true);
      curl_setopt($this->ch, CURLOPT_POSTFIELDS, $payload);
    }
    if($this->isHeader()){
      curl_setopt($this->ch, CURLOPT_HTTPHEADER,$this->header);
    }
    if($curlopt_header){
      // per la gestione dell'header nella risposta
      curl_setopt($this->ch, CURLOPT_VERBOSE, 1);
      curl_setopt($this->ch, CURLOPT_HEADER, 1);
    }else{
      curl_setopt($this->ch, CURLOPT_VERBOSE, 0);
      curl_setopt($this->ch, CURLOPT_HEADER, 0);
    }

    // Submit the POST request
    $result = curl_exec($this->ch);

    if($result === false)
    {
        echo 'Curl error: ' . curl_error($this->ch)."</br>";
        echo '</br> Curl error number: '.curl_errno($this->ch);
    }
    else
    {
        return $result;
    }

  }

  // metodo per ottenere la dimensione dell'header di risposta della Curl
  public function getHeaderSize(){
    return curl_getinfo($this->ch, CURLINFO_HEADER_SIZE);
  }

  // metodo per ottenere array dei parametri dell'header
  public function getHeaderParam($strParam){
    $headers=array();
    $data = explode(PHP_EOL,$strParam);
    //$data=array_shift($data);
    return $data;
  }
}



// classe per la gestione degli hash e-tag usati negli header delle chiamate ad HYPER API
class eTag{
  public $tabella;
  public $db;
  // costruttore
  public function __construct($tabella,$db){
    $this->tabella=$tabella;
    $this->db=$db;
  }
  // metodo per ottenere il tag per una relativa chiamata
  public function get_tag($tipo){
    $query = "SELECT * FROM ".$this->tabella." WHERE TIPO_CHIAMATA = '".$tipo."'";
    $result = $this->db->query($query, false);
    $row = $this->db->fetchByAssoc($result);
    return $row['CHIAVE'];
  }
  // metodo per settare un tag in funzione di una particolare chiamata
  public function set_tag($tipo,$tag){
    $query = "UPDATE ".$this->tabella." SET CHIAVE='".$tag."' WHERE TIPO_CHIAMATA='".$tipo."'";
    $result = $this->db->query($query, false);
  }
}



// funzione per creare un compito di segnalazione
// dato in input la stringa di segnalazione e il titolo del compito e l'idi assegnatario


function createAvvisoTask($task_title, $nota, $assignedType) {
    // Parametri di connessione
    global $sugar_config;
    
    // Creo un nuovo bean Tasks
    $task = BeanFactory::newBean('Tasks');
    
    // Imposto i campi del task
    $task->name = $task_title;
    $task->description = $nota;
    $task->status = 'Not Started';
    $task->priority = 'High';
    
    // Assegno il task in base al tipo specificato
    if (!empty($assignedType)) {
        
        // verifico se esiste la chiave $assignedType in $sugar_config['idsTaskNotify']
        if (isset($sugar_config['idsTaskNotify'][$assignedType])) {
            $task->assigned_user_id = $sugar_config['idsTaskNotify'][$assignedType];
        } else {
            // Assegno il task all'amministratore come fallback
            $admin = BeanFactory::getBean('Users');
            $admin->retrieve_by_string_fields(array('is_admin' => '1'), true);
            if (!empty($admin->id)) {
                $task->assigned_user_id = $admin->id;
                $GLOBALS['log']->info('Task assegnato all\'amministratore: ' . $admin->user_name);
            } else {
                $GLOBALS['log']->error('Impossibile trovare un amministratore per l\'assegnazione del task.');
                return false;
            }
        }
    }
    
    // Imposto il creatore del task come l'utente corrente o un utente di sistema
    global $current_user;
    if (!empty($current_user->id)) {
        $task->created_by = $current_user->id;
        $task->modified_user_id = $current_user->id;
    } else {
        // Utilizzo un utente di sistema se non c'è un utente corrente
        $admin = BeanFactory::getBean('Users');
        $admin->retrieve_by_string_fields(array('is_admin' => '1'), true);
        if (!empty($admin->id)) {
            $task->created_by = $admin->id;
            $task->modified_user_id = $admin->id;
        }
    }
    
    // Salvo il task
    $task->save();
    
    // Invio notifica all'assegnatario del task
    if (!empty($task->id) && !empty($task->assigned_user_id)) {
        try {
            // Carico l'utente assegnatario
            $assignedUser = BeanFactory::getBean('Users', $task->assigned_user_id);
            
            if (!empty($assignedUser->id)) {
                // Verifico se il modulo Notifications esiste
                
                // Il modulo Notifications non esiste, provo con il modulo Alerts se disponibile
                $alert = BeanFactory::newBean('Alerts');
                
                if ($alert) {
                    $alert->name = 'Nuovo compito assegnato: ' . $task_title;
                    $alert->description = 'Ti è stato assegnato un nuovo compito: ' . $task_title . "\n\n" . $nota;
                    $alert->target_module = 'Tasks';
                    $alert->type = 'info';
                    $alert->assigned_user_id = $assignedUser->id;
                    $alert->is_read = 0;
                    $alert->url_redirect = 'index.php?module=Tasks&action=DetailView&record=' . $task->id;
                    $alert->save();

                    // invia mail di notifica
                    //$beanUser=BeanFactory::getBean('Users',$bean->assigned_user_id);
                    $sea = new SugarEmailAddress;
                    $primary = $sea->getPrimaryAddress($assignedUser);

                    // Verifica che l'indirizzo email sia valido
                    if (empty($primary)) {
                        $GLOBALS['log']->error('Impossibile inviare email: indirizzo email non trovato per l\'utente ' . $assignedUser->user_name);
                    } else {
                        $GLOBALS['log']->info('Tentativo di invio email a: ' . $primary);

                        // Prepara un corpo email più dettagliato e in HTML
                        $emailBody = nl2br($alert->description);
                        $emailBody .= "<br><br>Per visualizzare il compito, <a href='{$sugar_config['site_url']}/index.php?module=Tasks&action=DetailView&record={$task->id}'>clicca qui</a>.";
                        
                        // send email
                        require_once('include/SugarPHPMailer.php');
                        $emailObj = new Email();
                        $defaults = $emailObj->getSystemDefaultEmail();
                        
                        // Verifica che le impostazioni email di sistema siano valide
                        if (empty($defaults['email'])) {
                            $GLOBALS['log']->error('Impossibile inviare email: indirizzo email di sistema non configurato');
                        } else {
                            $mail = new SugarPHPMailer();
                            $mail->setMailerForSystem();
                            $mail->From = $defaults['email'];
                            $mail->FromName = $defaults['name'];
                            $mail->Subject = $alert->name;
                            
                            // Imposta sia il corpo HTML che il testo alternativo
                            $mail->isHTML(true);
                            $mail->Body = $emailBody;
                            $mail->AltBody = strip_tags(str_replace("<br>", "\n", $emailBody));
                            
                            $mail->prepForOutbound();
                            $mail->AddAddress($primary);
                            
                            // Aggiungi debug per verificare le impostazioni SMTP
                            $mail->SMTPDebug = 1; // Imposta a 2 per debug più dettagliato
                            ob_start();
                            $result = $mail->Send();
                            $debugOutput = ob_get_clean();
                            
                            // Registra il risultato dell'invio e il debug SMTP
                            if ($result) {
                                $GLOBALS['log']->info('Email inviata con successo a: ' . $primary);
                            } else {
                                $GLOBALS['log']->error('Errore nell\'invio dell\'email: ' . $mail->ErrorInfo);
                                $GLOBALS['log']->error('Debug SMTP: ' . $debugOutput);
                            }
                            
                            // Salva l'email nel CRM
                            try {
                                $emailRecord = BeanFactory::newBean('Emails');
                                $emailRecord->name = $alert->name;
                                $emailRecord->description = $alert->description;
                                $emailRecord->description_html = $emailBody;
                                $emailRecord->to_addrs = $primary;
                                $emailRecord->type = 'out';
                                $emailRecord->status = $result ? 'sent' : 'failed';
                                $emailRecord->parent_type = 'Tasks';
                                $emailRecord->parent_id = $task->id;
                                $emailRecord->save();
                                
                                // Crea relazione con l'utente
                                $emailRecord->load_relationship('users');
                                if (!empty($emailRecord->users)) {
                                    $emailRecord->users->add($assignedUser->id);
                                }
                            } catch (Exception $e) {
                                $GLOBALS['log']->error('Errore nel salvare il record email: ' . $e->getMessage());
                            }
                        }
                    }
                    
                    $GLOBALS['log']->info('Alert inviato all\'utente: ' . $assignedUser->user_name . ' per il task: ' . $task->id);
                } else {
                    $GLOBALS['log']->warning('Impossibile inviare notifica: moduli Notifications e Alerts non disponibili');
                }
                
            }
        } catch (Exception $e) {
            $GLOBALS['log']->error('Errore durante l\'invio della notifica: ' . $e->getMessage());
        }
    }
    
}


// funzione per creare un record nel database di ETOS in SQL Server
function creaRecordInETOS($beanFidelityCard,$emailAddr){
    
    // Parametri di connessione
    global $db,$sugar_config;
    $server = $sugar_config['db_config']['etos_connection']['server'];
    $database = $sugar_config['db_config']['etos_connection']['database'];
    $username = $sugar_config['db_config']['etos_connection']['username'];
    $password = $sugar_config['db_config']['etos_connection']['password'];

    $email="";
    if (preg_match('/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/', $emailAddr)) {
        $email=$emailAddr;
    }
    else {
        // se non è un indirizzo email, uso il nome utente come email
        $email='na';
    }

    
    // eseguo la query
    try {
        // Creare la stringa di connessione con opzioni per gestire il certificato autofirmato
        $dsn = "sqlsrv:Server=$server;Database=$database;TrustServerCertificate=1";
        
        // Opzioni di connessione
        $options = array(
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        );
    
        // Creare la connessione PDO
        $conn = new PDO($dsn, $username, $password, $options);
    
        // Query per ottenere l'elenco delle tabelle
        // Preparare la query con parametri per evitare SQL injection
        $query = "
INSERT INTO [dbo].[USR_CLIENTICRM]
           ([DISPLAYNAME]
           ,[UID]
           ,[TEL]
           ,[EMAIL]
           ,[TIPO_FIDELITY]
           ,[PUNTEGGIO_TOT]
           ,[ALLINEATA_ETOS]
           ,[OLD_FIDELITY]
           ,[DATA_NASCITA])
     VALUES
           (:displayname
           ,:uid
           ,:tel
           ,:email
           ,:tipo_fidelity
           ,:punteggio_tot
           ,0
           ,:old_fidelity
           ,:data_nascita);
        ";
        
        // Preparare lo statement
        $stmt = $conn->prepare($query);

        // ottengo il nome della fascia collegata
        $query="
        SELECT ffd.id, ffd.name 
        FROM ffd_fascefidelity ffd
            INNER JOIN  ffd_fascefidelity_cstm ffdc
            ON	ffd.id = ffdc.id_c
                INNER JOIN ffd_fascefidelity_fc_fidelitycard_1_c ffdfd
                ON ffd.id = ffdfd.ffd_fascefidelity_fc_fidelitycard_1ffd_fascefidelity_ida
                    INNER JOIN fc_fidelitycard fc
                    ON ffdfd.ffd_fascefidelity_fc_fidelitycard_1fc_fidelitycard_idb = fc.id
        WHERE fc.id='".$beanFidelityCard->id."'
        AND ffdfd.deleted = 0
        ";

        

        $result = $db->query($query);
        $row = $db->fetchRow($result);

        if($row){
            $fascia = $row['name'];
        }
        else {
            $fascia = 'Nessuna fascia collegata';
        }
    
        //write_to_log(array(), "la fascia collegata: \n".$fascia);
        // Associare i parametri
        $stmt->bindParam(':displayname', $beanFidelityCard->first_name);
        $stmt->bindParam(':uid', $beanFidelityCard->guid_webapp_c);
        $stmt->bindParam(':tel', $beanFidelityCard->phone_home);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':tipo_fidelity', $fascia);
        $stmt->bindParam(':punteggio_tot', $beanFidelityCard->punteggio_totale_c);
        $stmt->bindParam(':old_fidelity', $beanFidelityCard->oldid_c);

        // Converti la data nel formato YYYYMMDD
        $dataNascita = '';
        if (!empty($beanFidelityCard->data_nascita_c)) {
            // Verifica il formato della data attuale e convertila
            $timestamp = strtotime($beanFidelityCard->data_nascita_c);
            if ($timestamp !== false) {
                $dataNascita = date('Ymd', $timestamp);
            } else {
                // Se la conversione fallisce, registra un avviso
                $GLOBALS['log']->warning('Impossibile convertire la data di nascita: ' . $beanFidelityCard->data_nascita_c);
                $dataNascita = '';
            }
        }

        $stmt->bindParam(':data_nascita', $dataNascita);

              
        // deubg
        $paramsString = $beanFidelityCard->first_name . ' - ' . 
        $beanFidelityCard->guid_webapp_c . ' - ' . 
        $beanFidelityCard->phone_home . ' - ' . 
        $email . ' - ' . 
        $fascia . ' - ' . 
        $beanFidelityCard->punteggio_totale_c;

        //write_to_log(array(), "Parametri bindati: " . $paramsString);

        // Eseguire la query
        $result = $stmt->execute();
        
        if ($result) {
            $GLOBALS['log']->info('Record creato con successo in ETOS per l\'utente: ' . $beanFidelityCard->first_name);
            return true;
        } else {
            $GLOBALS['log']->error('Errore nella creazione del record in ETOS per l\'utente: ' . $beanFidelityCard->first_name);
            // Crea un compito di segnalazione
            $task_title="ERRORE nel creare utente in ETOS";
            $nota = "Utente con UID: \n\n ".$beanFidelityCard->guid_webapp_c." \n\n non creato in ETOS! Verifica!";
            $assignedType = "UserBackoffice";
            createAvvisoTask($task_title, $nota, $assignedType);
            return false;
        }
            
    } catch(PDOException $e) {
        // Gestione degli errori con informazioni dettagliate
        $errorInfo = '';
        
        // Ottieni informazioni dettagliate sull'errore
        if ($e->getCode()) {
            $errorInfo .= 'Codice errore: ' . $e->getCode() . '; ';
        }
        
        // Ottieni informazioni aggiuntive se disponibili
        if (method_exists($e, 'errorInfo') && $e->errorInfo) {
            $errorInfo .= 'SQL State: ' . ($e->errorInfo[0] ?? 'N/A') . '; ';
            $errorInfo .= 'Driver Error Code: ' . ($e->errorInfo[1] ?? 'N/A') . '; ';
            $errorInfo .= 'Driver Error Message: ' . ($e->errorInfo[2] ?? 'N/A') . '; ';
        }
        
        // Aggiungi informazioni sul server e database (senza password)
        $errorInfo .= 'Server: ' . $server . '; Database: ' . $database . '; ';
        
        // Aggiungi traccia dello stack per debug avanzato
        $errorInfo .= 'Stack Trace: ' . $e->getTraceAsString();
        
        // Registra l'errore dettagliato
        $GLOBALS['log']->error('Errore di connessione al database ETOS: ' . $e->getMessage());
        $GLOBALS['log']->error('Dettagli errore SQL Server: ' . $errorInfo);
        
        // Crea un compito di segnalazione per l'errore di database
        $task_title = "ERRORE critico connessione database ETOS";
        $nota = "Si è verificato un errore di connessione al database ETOS.\n\n" .
                "Messaggio: " . $e->getMessage() . "\n\n" .
                "Dettagli: " . $errorInfo;
        $assignedType = "UserBackoffice";
        createAvvisoTask($task_title, $nota, $assignedType);
        
        return false;
    }

}

// funzione per verificare se un vecchio cliente era presente in ETOS
function isVecchioCliente($oldId,$beanFidelityCard){
    // Parametri di connessione
    global $db,$sugar_config;
    $server = $sugar_config['db_config']['etos_connection']['server'];
    $database = $sugar_config['db_config']['etos_connection']['database'];
    $username = $sugar_config['db_config']['etos_connection']['username'];
    $password = $sugar_config['db_config']['etos_connection']['password'];
    
    // eseguo la query
    try {
        // Creare la stringa di connessione con opzioni per gestire il certificato autofirmato
        $dsn = "sqlsrv:Server=$server;Database=$database;TrustServerCertificate=1";
        
        // Opzioni di connessione
        $options = array(
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        );

        // Creare la connessione PDO
        $conn = new PDO($dsn, $username, $password, $options);

        // Query per ottenere l'elenco delle tabelle
        // Preparare la query con parametri per evitare SQL injection
        $query = "
    select usr_fidelity,usr_fidelityattiva
    from CLIFO  
    where usr_fidelity=:usr_fidelity
    and usr_fidelityattiva='S'
        ";
        
        // Preparare lo statement
        $stmt = $conn->prepare($query);

        //write_to_log(array(), "la fascia collegata: \n".$fascia);
        // Associare i parametri
        $stmt->bindParam(':usr_fidelity', $oldId);
    
        // Eseguire la query
        $result = $stmt->execute();
        
        if ($result) {
            //write_to_log(array(),"result Ok con  oldID: ".$oldId);
            // Verifica se ci sono righe restituite
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if (count($rows) > 0) {
                //write_to_log(array(),"oldid trovato con ID: ".$oldId);
                // match trovato un vecchio cliente
                $beanFidelityCard->oldid_c=$oldId;
                $beanFidelityCard->save();
                return true;
            } else {
                // match non trovato un vecchio cliente
                return false;
            }
        } else {
            $GLOBALS['log']->error('Errore nella ricerca dei dati dal database per vecchia Fidelity: '. $oldId);
            // Crea un compito di segnalazione
            $task_title="ERRORE ricerca vecchio cliente in ETOS";
            $nota = "Utente con UID: \n\n ".$beanFidelityCard->guid_webapp_c." \n\n non riesce a recuperare la vecchia fidelity con id: ". $oldId;
            $assignedType = "UserBackoffice";
            createAvvisoTask($task_title, $nota, $assignedType);
            return false;
        }

    }
    catch(PDOException $e) {
        $GLOBALS['log']->error('Errore nella ricerca dei dati dal database per vecchia Fidelity: '. $oldId);
        // Crea un compito di segnalazione
        $task_title="ERRORE ricerca vecchio cliente in ETOS";
        $nota = "Utente con UID: \n\n ".$beanFidelityCard->guid_webapp_c." \n\n non riesce a recuperare la vecchia fidelity con id: ". $oldId;
        $assignedType = "UserBackoffice";
        createAvvisoTask($task_title, $nota, $assignedType);
        return false;
    }
    
}

// funzione per assegnare al modulo FC_FidelityCard la fascia di fidelity corrispondente del modulo FFD_FasceFidelity in base al punteggio passato
function assegnaFascieFidelity($beanFidelityCard, $punteggio){
    // Parametri di connessione
    global $db,$sugar_config;
    $beanFascia = BeanFactory::getBean('FFD_FasceFidelity');
    // da modulo FC_FidelityCard, elimino se ci sono precedenti relazioni col modulo FFD_FasceFidelity mediante la relazione  ffd_fascefidelity_fc_fidelitycard_1
    $beanFidelityCard->load_relationship('ffd_fascefidelity_fc_fidelitycard_1');
    $beanFidelityCard->ffd_fascefidelity_fc_fidelitycard_1->delete($beanFidelityCard->id,$beanFascia);
    // trovo l'id del record del modulo FFD_FasceFidelity dove il punteggio passato è compreso tra i campi soglia_iniziale_c e soglia_finale_c
    $query="
    SELECT ffd.id, ffd.name 
    FROM ffd_fascefidelity ffd
        INNER JOIN  ffd_fascefidelity_cstm ffdc
        ON	ffd.id = ffdc.id_c
    WHERE ".$punteggio." >= ffdc.soglia_iniziale_c
    AND ".$punteggio." <= ffdc.soglia_finale_c";

    $result = $db->query($query);
    $row = $db->fetchByAssoc($result);
    // se trovo un record, creo una nuova relazione col modulo FC_FidelityCard con il modulo FFD_FasceFidelity
    if ($row) {
        $beanFidelityCard->load_relationship('ffd_fascefidelity_fc_fidelitycard_1');
        $beanFidelityCard->ffd_fascefidelity_fc_fidelitycard_1->add($row['id']);
        $GLOBALS['log']->info('Fascia di fidelity assegnata correttamente per l\'utente: '. $beanFidelityCard->first_name.' - Punteggio: '. $punteggio);
        return $row['name'];
    } else {
        $GLOBALS['log']->error('Nessuna fascia di fidelity trovata per il punteggio: '. $punteggio.' per l\'utente: '. $beanFidelityCard->first_name);
        return 'Nessuna fascia di fidelity';
    }

}

// funzione per il calcolo del punteggio totale da utilizzare nei crediti fidelity card
function calcoloPunteggio($totaleScontrino,$beanFidelityCard){
    // calcolo intanto il punteggio in base al totale spesa
    $beanFidelityCard->load_relationship('ffd_fascefidelity_fc_fidelitycard_1');
    $relatedFasciaIds = $beanFidelityCard->ffd_fascefidelity_fc_fidelitycard_1->get();

    $totaleScontrinoClean = str_replace('.', '', $totaleScontrino);
    $totaleScontrinoClean = str_replace(',', '.', $totaleScontrinoClean);
    // Convertiamo la stringa pulita in float
    $totaleScontrinoFloat = floatval($totaleScontrinoClean);

    if (!empty($relatedFasciaIds)) {
        $fasciaId = reset($relatedFasciaIds); // Prende il primo ID dall'array
        $beanFascia = BeanFactory::getBean('FFD_FasceFidelity', $fasciaId);
        
        if ($beanFascia) {
            // Ora possiamo usare $beanFascia
            $punteggio = round(($totaleScontrinoFloat / $beanFascia->daeuro_c) * $beanFascia->topoint_c);
        } else {
            $GLOBALS['log']->error('Fascia di fidelity non trovata per ID: ' . $fasciaId);
            $punteggio = 0; // O un altro valore predefinito
        }
    } else {
        $GLOBALS['log']->warning('Nessuna fascia di fidelity associata per l\'utente: ' . $beanFidelityCard->id);
        $punteggio = 0; // O un altro valore predefinito
    }

    return $punteggio;
}

// funzione che dato il guid di Firebase recupera il bean del record FC_FidelityCard, crea un record TNP_TokenNotificationPush e crea una relazione col modulo FC_FidelityCard 
function creaTokenNotificationPush($uid,$token){
    // Parametri di connessione
    global $db,$sugar_config;
    
    // verifico se $uid non è vuoto
    if(empty($uid)){
        // se $uid è vuoto, restituisco un errore 400 Bad Request
        header_remove('Set-Cookie');
        
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        echo json_encode(['message' => 'uid non presente']);
        exit;
    }

    // ottengo i dati della fidelity legati al guid
    // Cerco tra tutti i record del Bean FC_FidelityCard se il valore del uid è presente nel campo custom 'guid_webapp_c'
    $bean = BeanFactory::getBean('FC_FidelityCard');

    if (!$bean) {
        throw new Exception('Impossibile inizializzare il bean FC_FidelityCard');
    }

   // Metodo sicuro usando retrieve_by_string_fields
    $fidelityCard = $bean->retrieve_by_string_fields(array(
        'guid_webapp_c' => $uid,
        'deleted' => 0
    ));

    if ($fidelityCard && !empty($fidelityCard->id) && !empty($token)) {
        // il guid è stato trovato in un record FC_FidelityCard
        // recupero i dati della fidelity
        $beanFidelityCard = $fidelityCard;
        // Verifico se il token è già presente per questa fidelity card
        $beanFidelityCard->load_relationship('fc_fidelitycard_tnp_tokennotificationpush_1');
        $relatedTokens = $beanFidelityCard->fc_fidelitycard_tnp_tokennotificationpush_1->getBeans();
        
        $tokenExists = false;
        foreach ($relatedTokens as $relatedToken) {
            if ($relatedToken->name === $token) {
                $tokenExists = true;
                break;
            }
        }

        // Se il token non esiste, lo creo e lo associo
        if (!$tokenExists) {
            $tokenBean = BeanFactory::newBean('TNP_TokenNotificationPush');
            $tokenBean->name = $token;
            //$tokenBean->assigned_user_id = $beanFidelityCard->assigned_user_id; // Assegno allo stesso utente della fidelity
            $tokenBean->save();

            // Creo la relazione
            $beanFidelityCard->fc_fidelitycard_tnp_tokennotificationpush_1->add($tokenBean->id);
            $GLOBALS['log']->info('Nuovo token di notifica creato e associato alla fidelity card ID: ' . $beanFidelityCard->id);
        } else {
            $GLOBALS['log']->info('Token di notifica già esistente per la fidelity card ID: ' . $beanFidelityCard->id);
        }
    }
}



function write_to_log($arr, $str, $email = false) {

    date_default_timezone_set('Europe/Rome');
    $time_stamp = date("Y-m-d h:i:sa");

    // If the $arr is an object then convert it into an array first
    if(is_object($arr)) {
        $arr = serialize($arr);
        $arr = unserialize($arr);
        $txt = $str.PHP_EOL.PHP_EOL;
        $txt.= "<pre>".print_r($arr, true)."</pre>".PHP_EOL.PHP_EOL;
        file_put_contents('custom/log.txt', PHP_EOL.PHP_EOL, FILE_APPEND);
        file_put_contents('custom/log.txt', $txt, FILE_APPEND);
        file_put_contents('custom/log.txt', PHP_EOL.PHP_EOL, FILE_APPEND);
        return;
    }

    if(!empty($arr)) {

        // Get readable stacktrace info that will go into the array
        $content = unserialize(serialize(debug_backtrace()));
        $content = parse_into_string($content);

        $arr["Date_time"]  = $time_stamp; /* This date goes into the txt file only */
        $arr["StackTrace"] = $content;
        $txt = $str.":".PHP_EOL;
        $txt.= "<pre>".print_r($arr, true)."</pre>".PHP_EOL.PHP_EOL;

    } else {

        $txt = $str.PHP_EOL."(".$time_stamp.")".PHP_EOL.PHP_EOL;

    }

    file_put_contents('custom/log.txt', $txt, FILE_APPEND);

    # Now email
    if($email == true)
        email_update($txt, $str);

}
function email_update($msg, $title, $to = NULL) {

    if(!isset($to)) {
        $to = "marco.bullo@elinet.it";
    }

    $from = "SUITECRM <marco.bullo@elinet.it>";
    $headers = "From: SUITECRM <marco.bullo@elinet.it>\r\n";
    $headers .= 'MIME-Version: 1.0' . "\n";
    $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n"; #now mail

    try {
        mail($to, $title, $msg, $headers);
    } catch (Exception $e) {
        echo 'Caught exception: ',  $e->getMessage(), "\n";
    }

}


// Will take the content of the stack trace and parse it into a more manageable array
function parse_into_string($stackTrace) {

    $ignore = array(
      "custom_utils.ext.php",
    );

    $report = "";

    foreach ($stackTrace as $s) {

        // Skip any system file we wish to ignore
        if(isset($s["file"]) AND in_array(basename($s["file"]), $ignore) !== false) {
            continue;
        }

        if(isset($s["class"]))
            $report .= "Class: ".$s["class"]." ";

        if(isset($s["function"]))
            $report .= "Function/method: ".$s["function"]."() ";

        if(isset($s["file"]))
            $report .= "File: ".str_replace("/var/www/sites/x-crm-dev", "", $s["file"])." ";
//          $report .= "File: ".basename($s["file"])." ";

        if(isset($s["line"]))
            $report .= "on line: ".$s["line"]." ";

        $report .= " | ";

        // UNCOMMENT BELOW FOR FULL STACK TRACE
        break;

    }

    return $report;

}


?>